/*
 * unpack.h  -  Restore all definitions about structure packing
 *
 * Copyright (C) 2003-2007 Gero Kuhlmann   <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: unpack.h,v 1.5 2007/01/06 18:30:52 gkminix Exp $
 */

/*
 * We need to know about the compiler environment
 */
#ifndef COMPILE_SYSTEM
# include <compiler.h>
#endif



/*
 * To compile source files on the host which contains definitions for the
 * target system, structures have to be packed. The following restore the
 * normal host compiler behaviour of non-packing all structures.
 */
#if COMPILE_SYSTEM == COMPILER_HOST && defined(PACK_ENABLED)
# ifdef USE_PRAGMA_PACK
#  pragma pack()
# endif
# ifdef USE_PRAGMA_ALIGN
#  pragma options align=reset
# endif
# undef PACK_ENABLED
#endif

