/*
 * pnp.h  -  Definitions for ROM PnP header
 *
 * Copyright (C) 2003-2007 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: pnp.h,v 1.8 2007/01/06 18:31:10 gkminix Exp $
 */

#ifndef SYSTEM_PNP_H
#define SYSTEM_PNP_H


/*
 * Check the compile system and turn structure packing on
 */
#include <compiler.h>
#include <pack.h>



/*
 **************************************************************************
 *
 * Definitions for the PnP header found at the beginning of a boot rom.
 */

/* Flag mask for device indicator field */
#define PNP_DEVIND_DDIM		0x80	/* rom supports DDIM */
#define PNP_DEVIND_SHADOW	0x40	/* rom my be shadowed in ram */
#define PNP_DEVIND_CACHE	0x20	/* rom is read cacheable */
#define PNP_DEVIND_BOOT		0x10	/* rom only required for booting */
#define PNP_DEVIND_IPL		0x04	/* device is an IPL device */
#define PNP_DEVIND_INPUT	0x02	/* device is an input device */
#define PNP_DEVIND_DISP		0x01	/* device is a display device */


#ifndef _ASSEMBLY_

/* Structure holding a PnP expansion header */
struct pnphdr {
	__u8	sig[4];		/* Header signature */
	__u8	revision;	/* Header structure revision */
	__u8	size;		/* Size of header in 16-byte-blocks */
	__nptr	next;		/* Offset of next header */
	__u8	reserved1;
	__u8	chksum;		/* Header checksum */
	__u8	devid[4];	/* Device identifier */
	__nptr	manufacturer;	/* Pointer to manufacturer string */
	__nptr	productname;	/* Pointer to product name string */
	__u8	devtype[3];	/* Device type code */
	__u8	devind;		/* Device indicators */
	__nptr	bcv;		/* Boot connection vector */
	__nptr	dv;		/* Disconnect vector */
	__nptr	bev;		/* Bootstrap entry vector */
	__u16	reserved2;
	__u16	sriv;		/* Static resource information vector */
} PACKED;

#else /* _ASSEMBLY_ */

			.struct	0
pnphdr_sig:		.struct	.+4	# header signature
pnphdr_revision:	.struct	.+1	# header structure revision
pnphdr_size:		.struct	.+1	# size of header in 16-byte-blocks
pnphdr_next:		.struct	.+2	# offset of next header
pnphdr_reserved1:	.struct	.+1	# 
pnphdr_chksum:		.struct	.+1	# header checksum
pnphdr_devid:		.struct	.+4	# device identifier
pnphdr_manufacturer:	.struct	.+2	# pointer to manufacturer string
pnphdr_productname:	.struct	.+2	# pointer to product name
pnphdr_devtype:		.struct	.+3	# devcie type code
pnphdr_devind:		.struct	.+1	# device indicators
pnphdr_bcv:		.struct	.+2	# boot connection vector
pnphdr_dv:		.struct	.+2	# disconnect vector
pnphdr_bev:		.struct	.+2	# bootstrap entry vector
pnphdr_reserved2:	.struct	.+2	# 
pnphdr_sriv:		.struct	.+2	# static resource information vector

#endif /* _ASSEMBLY_ */


/* Signature of PnP expansion header */
#define PNP_SIGNATURE	"$PnP"



/*
 * Restore all definitions for data structure packing
 */
#include <unpack.h>

#endif

