/*
 * pci.h  -  Definitions for ROM PCI header
 *
 * Copyright (C) 2003-2007 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: pci.h,v 1.9 2007/01/06 18:31:10 gkminix Exp $
 */

#ifndef SYSTEM_PCI_H
#define SYSTEM_PCI_H


/*
 * Check the compile system and turn structure packing on
 */
#include <compiler.h>
#include <pack.h>



/*
 **************************************************************************
 *
 * Definitions for the PCI header found at the beginning of a boot rom.
 */

#ifndef _ASSEMBLY_

/* Structure holding a PCI expansion header */
struct pcihdr {
	__u8	sig[4];			/* Header signature */
	__u16	vendorid;		/* Vendor ID */
	__u16	deviceid;		/* Device ID */
	__nptr	vitaldata;		/* Pointer to vital data info */
	__u16	size;			/* Size of header in bytes */
	__u8	revision;		/* Structure revision */
	__u8	devtype[3];		/* Device type code */
	__u16	romlength;		/* ROM image length */
	__u16	version;		/* Version of ROM code */
	__u8	codetype;		/* PCI code type */
	__u8	devind;			/* Device indicator */
	__u16	reserved1;
} PACKED;

#else /* _ASSEMBLY_ */

			.struct	0
pcihdr_sig:		.struct	.+4	# header signature
pcihdr_vendorid:	.struct	.+2	# vendor ID
pcihdr_deviceid:	.struct	.+2	# device ID
pcihdr_vitaldata:	.struct	.+2	# pointer to vital data info
pcihdr_size:		.struct	.+2	# size of header in bytes
pcihdr_revision:	.struct	.+1	# structure revision
pcihdr_devtype:		.struct	.+3	# device type code
pcihdr_romlength:	.struct	.+2	# ROM image length
pcihdr_version:		.struct	.+2	# version of ROM code
pcihdr_codetype:	.struct	.+1	# PCI code type
pcihdr_devind:		.struct	.+1	# device indicator
pcihdr_reserved1:	.struct	.+2	# 

#endif /* _ASSEMBLY_ */


/* Size of PCI expansion header */
#define PCI_HDRSIZE	24


/* Signature of PCI expansion header */
#define PCI_SIGNATURE	"PCIR"


/* PCI network class codes */
#define PCI_BASE_NETWORK	0x02		/* network base class */

#define PCI_CLASS_ETHERNET	0x0200
#define PCI_CLASS_TOKEN_RING	0x0201
#define PCI_CLASS_FDDI		0x0202
#define PCI_CLASS_ATM		0x0203
#define PCI_CLASS_OTHER		0x0280



/*
 * Restore all definitions for data structure packing
 */
#include <unpack.h>

#endif

