/*
 * partition.h  -  Definition of a partition sector
 *
 * Copyright (C) 2003-2007 Gero Kuhlmann   <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: partition.h,v 1.7 2007/01/06 18:31:10 gkminix Exp $
 *
 */

#ifndef SYSTEM_PARTITION_H
#define SYSTEM_PARTITION_H


/*
 * Check the compile system and turn structure packing on
 */
#include <compiler.h>
#include <pack.h>



/*
 * Layout of a disk partition sector
 */
#define PART_TABLE_OFS		0x01BE	/* offset of partition table */
#define PART_SIG_OFS		0x01FE	/* offset of signature */
#define PART_SIG		0xAA55	/* partition table signature */

#define PART_ACTIVE		0x80	/* marks active partition */
#define PART_TYPE_EXT		0x05	/* type for extended partition */
#define PART_TYPE_12		0x01	/* partition type (FAT12) */
#define PART_TYPE_16_SMALL	0x04	/* partition type (FAT16 < 32M) */
#define PART_TYPE_16_LARGE	0x06	/* partition type (FAT16 > 32M) */


#ifndef _ASSEMBLY_

struct partition {
  __u8     status;			/* status of entry */
  __u8     first_head;			/* start head for partition */
  __u8     first_sector;		/* start sector of partition */
  __u8     first_track;			/* start track of partition */
  __u8     type;			/* partition type */
  __u8     last_head;			/* end head for partition */
  __u8     last_sector;			/* end sector of partition */
  __u8     last_track;			/* end track of partition */
  __long   first_abs_sector;		/* first absolute sector num */
  __long   number_sectors;		/* number of sectors */
} PACKED;

#else

			.struct	0
part_status:		.struct	.+1	/* status of entry */
part_first_head:	.struct	.+1	/* start head of partition */
part_first_sector:	.struct	.+1	/* start sector of partition */
part_first_track:	.struct	.+1	/* start track of partition */
part_type:		.struct	.+1	/* partition type */
part_last_head:		.struct	.+1	/* end head of partition */
part_last_sector:	.struct	.+1	/* end sector of partition */
part_last_track:	.struct	.+1	/* end track of partition */
part_first_abs_sect:	.struct	.+4	/* first absolute sector num */
part_number_sectors:	.struct	.+4	/* number of sectors */

#define PART_SIZE	16		/* size of partition entry */

#endif /* _ASSEMBLY_ */



/*
 * Restore all definitions for data structure packing
 */
#include <unpack.h>

#endif

