/*
 * nbloader.h  -  Define the structure of a netboot image loader program
 *
 * Copyright (C) 2003-2007 Gero Kuhlmann   <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: nbloader.h,v 1.7 2007/01/06 18:31:09 gkminix Exp $
 */

#ifndef SYSTEM_NBLOADER_H
#define SYSTEM_NBLOADER_H


/*
 * Check the compile system and turn structure packing on
 */
#include <compiler.h>
#include <pack.h>



/*
 * All netboot boot image loader programs have a common header. This
 * header will be used by the corresponding mknbi program to create
 * a proper tagged image file.
 */
#define MIN_STK_SIZE	2048		/* common minimum stack size */

#define NBLD_OFFSET	0x0004		/* offset to nbld_header struct */

#ifndef _ASSEMBLY_

struct nbld_header {
  __u16          textsize;		/* size of text segment */
  __u16          datasize;		/* size of data segment */
  __u16          heapsize;		/* required min. heap size */
  __u16          stacksize;		/* required min. stack size */
  __u16          nbsetup;		/* offset to setup routine */
  __u16          nbstart;		/* offset to loader routine */
  __u16          vendid;		/* offset to vendor ID */
  __u16          copyright;		/* offset to copyright msg */
  __u16          userptr;		/* offset to user data */
} PACKED;

#else

		.struct	NBLD_OFFSET
nbld_textsize:	.struct	.+2		/* size of text segment */
nbld_datasize:	.struct	.+2		/* size of data segment */
nbld_heapsize:	.struct	.+2		/* required min. heap size */
nbld_stacksize:	.struct	.+2		/* required min. stack size */
nbld_nbsetup:	.struct	.+2		/* offset to setup routine */
nbld_nbstart:	.struct	.+2		/* offset to loader routine */
nbld_vendid:	.struct	.+2		/* offset to vendor ID */
nbld_copyright:	.struct	.+2		/* offset to copyright msg. */
nbld_userptr:	.struct	.+2		/* offset to user data */

#define NBLD_SIZE	22		/* size of structure */

#endif




/*
 * Restore all definitions for data structure packing
 */
#include <unpack.h>

#endif

