/*
 * romid.h  -  Define the PXE ROMID structures
 *
 * Copyright (C) 2003-2007 Gero Kuhlmann   <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: romid.h,v 1.8 2007/01/06 18:31:04 gkminix Exp $
 */

#ifndef PXE_ROMID_H
#define PXE_ROMID_H


/*
 * Check the compile system and turn structure packing on
 */
#include <compiler.h>
#include <pack.h>



/*
 **************************************************************************
 *
 * This file contains the Preboot API ROMID and loader structure definitions
 * as per Intels PXE specification version 2.1.
 *
 **************************************************************************
 */


/*
 **************************************************************************
 *
 * Definition of UNDI ROMID structure
 */

#ifndef _ASSEMBLY_

struct s_undi_romid {
	__u8   signature[4];		/* ROMID structure signature */
	__u8   length;			/* length of this structure */
	__u8   checksum;		/* makes checksum of struct zero */
	__u8   revision;		/* structure revision */
	__u8   undirev[3];		/* UNDI API revision number */
	__u16  loadofs;			/* offset to UNDI loader */
	__u16  stacksize;		/* required stack size */
	__u16  datasize;		/* required data size */
	__u16  codesize;		/* required code size */
	__u8   bustype[4];		/* ASCII bus type string */
} PACKED;

typedef struct s_undi_romid t_undi_romid;


#else

			.struct	0
o_ur_sig:		.struct	.+4	/* ROMID structure signature */
o_ur_length:		.struct	.+1	/* length of this structure */
o_ur_checksum:		.struct	.+1	/* makes checksum of struct zero */
o_ur_revision:		.struct	.+1	/* structure revision */
o_ur_undirev:		.struct	.+3	/* UNDI API revision number */
o_ur_loadofs:		.struct	.+2	/* offset to UNDI loader */
o_ur_stacksize:		.struct	.+2	/* required stack size */
o_ur_datasize:		.struct	.+2	/* required data size */
o_ur_codesize:		.struct	.+2	/* required code size */
o_ur_bustype:		.struct	.+4	/* ASCII bus type string */

#define UNDI_ROMID_SIZE		0x0016	/* size of UNDI ROMID structure */

#endif /* _ASSEMBLY_ */


/* UNDI ROMID signature string */
#define UNDI_ROMID_SIG		"UNDI"



/*
 **************************************************************************
 *
 * Definition of kernel ROMID structure
 */

#ifndef _ASSEMBLY_

struct s_kernel_romid {
	__u8   signature[4];		/* ROMID structure signature */
	__u8   length;			/* length of this structure */
	__u8   checksum;		/* makes checksum of struct zero */
	__u8   revision;		/* structure revision */
	__u8   undirev[3];		/* kernel API revision number */
	__u16  loadofs;			/* offset to kernel loader */
	__u16  stacksize;		/* required stack size */
	__u16  datasize;		/* required data size */
	__u16  codesize;		/* required code size */
} PACKED;

typedef struct s_kernel_romid t_kernel_romid;


#else

			.struct	0
o_kr_sig:		.struct	.+4	/* ROMID structure signature */
o_kr_length:		.struct	.+1	/* length of this structure */
o_kr_checksum:		.struct	.+1	/* makes checksum of struct zero */
o_kr_revision:		.struct	.+1	/* structure revision */
o_kr_undirev:		.struct	.+3	/* kernel API revision number */
o_kr_loadofs:		.struct	.+2	/* offset to kernel loader */
o_kr_stacksize:		.struct	.+2	/* required stack size */
o_kr_datasize:		.struct	.+2	/* required data size */
o_kr_codesize:		.struct	.+2	/* required code size */

#define KERNEL_ROMID_SIZE	0x0012	/* size of UNDI ROMID structure */

#endif /* _ASSEMBLY_ */


/* kernel ROMID signature string */
#define KERNEL_ROMID_SIG	"$BC$"



/*
 * Restore all definitions for data structure packing
 */
#include <unpack.h>

#endif

