/* vim: set filetype=c:
 *
 * general.h  -  Common PXE definitions
 *
 * Copyright (C) 2003-2007 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: general.h,v 1.5 2007/01/06 18:31:03 gkminix Exp $
 */

#ifndef PXE_GENERAL_H
#define PXE_GENERAL_H


/*
 * Check the compile system and turn structure packing on
 */
#include <compiler.h>
#include <pack.h>



/*
 **************************************************************************
 *
 * This file contains the Preboot API common definitions as
 * per Intels PXE specification version 2.1.
 *
 **************************************************************************
 *
 * CPU types (defined in WfM 1.1):
 */
#define PXENV_CPU_X86		0
#define PXENV_CPU_ALPHA		1
#define PXENV_CPU_PPC		2



/*
 **************************************************************************
 *
 * Bus types (defined in WfM 1.1):
 */
#define PXENV_BUS_ISA		0
#define PXENV_BUS_EISA		1
#define PXENV_BUS_MCA		2
#define PXENV_BUS_PCI		3
#define PXENV_BUS_VESA		4
#define PXENV_BUS_PCMCIA	5



/*
 * Restore all definitions for data structure packing
 */
#include <unpack.h>

#endif

