/*
 * exitcodes.h  -  Exit codes for all netboot programs
 *
 * Copyright (C) 1998-2007 Gero Kuhlmann   <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: exitcodes.h,v 1.21 2007/01/06 18:30:52 gkminix Exp $
 */

#ifndef EXITCODES_H
#define EXITCODES_H


/*
 * Definition of exit codes
 *   0x00 - 0x1f  general exit codes for all programs
 *   0x20 - 0x3f  exit codes for makerom
 *   0x40 - 0x5f  exit codes for mknbi-linux
 *   0x60 - 0x7f  exit codes for mknbi-dos
 *   0x80 - 0x9f  exit codes for mknbi-mgl
 */
#ifndef EXIT_SUCCESS
#define EXIT_SUCCESS		0x00		/* no error */
#endif
#define EXIT_USAGE		0x01		/* usage */
#define EXIT_MEMORY		0x02		/* not enough memory */
#define EXIT_OPEN		0x03		/* cannot open file */
#define EXIT_CREATE		0x04		/* cannot create file */
#define EXIT_READ		0x05		/* read error */
#define EXIT_WRITE		0x06		/* write error */
#define EXIT_ACCESS		0x07		/* error accessing file */
#define EXIT_TEMPNAME		0x08		/* error generating temp name */
#define EXIT_SEEK		0x09		/* seek error */
#define EXIT_OPENDIR		0x0A		/* error opening directory */
#define EXIT_INTERNAL		0x0B		/* internal error */
#define EXIT_HOSTNAME		0x0C		/* invalid hostname */
#define EXIT_HOSTADDR		0x0D		/* invalid host address */
#define EXIT_INET		0x0E		/* no INET support */
#define EXIT_STAT		0x0F		/* cannot stat file or dir */
#define EXIT_CONFIG		0x10		/* error in config file */
#define EXIT_DB			0x11		/* error in database file */
#define EXIT_NODB		0x12		/* no database specified */
#define EXIT_NOSYS		0x13		/* system not in database */
#define EXIT_NOTSUPPORTED	0x14		/* function not supported */
#define EXIT_FCNTL		0x15		/* fcntl failed */
#define EXIT_LOCK		0x16		/* error locking a file */
#define EXIT_SIGNAL		0x17		/* signal received */
#define EXIT_LOGFILE		0x18		/* error writing log file */
#define EXIT_HELP		0x19		/* help file error */
#define EXIT_CONSOLE		0x1A		/* error accessing console */
#define EXIT_EXEC		0x1B		/* error executing file */
#define EXIT_SELECT		0x1C		/* error on select function */
#define EXIT_LOCALE		0x1D		/* error selecting locale */

#define EXIT_MAKEROM_OPENKERN	0x20		/* unable to open kernel */
#define EXIT_MAKEROM_READKERN	0x21		/* unable to read kernel */
#define EXIT_MAKEROM_INVKERN	0x22		/* invalid kernel version */
#define EXIT_MAKEROM_OPENDRV	0x23		/* unable to open driver */
#define EXIT_MAKEROM_EXEEOF	0x24		/* unexpected end of EXE file */
#define EXIT_MAKEROM_SIZE	0x25		/* output file too large */
#define EXIT_MAKEROM_OPENLDR	0x26		/* unable to open loader */
#define EXIT_MAKEROM_NETFND	0x27		/* no network drivers found */
#define EXIT_MAKEROM_KERNEOF	0x28		/* unexpected end of kernel */
#define EXIT_MAKEROM_ROMEOF	0x29		/* unexpected end of rom */
#define EXIT_MAKEROM_IMAGESIZE	0x2B		/* flash image too large */
#define EXIT_MAKEROM_INVEXE	0x2C		/* Invalid EXE file header */
#define EXIT_MAKEROM_INVDRV	0x2D		/* invalid network driver */
#define EXIT_MAKEROM_INVLDR	0x2E		/* invalid loader */
#define EXIT_MAKEROM_OPENNET	0x2F		/* unable to open net driver */
#define EXIT_MAKEROM_READNET	0x30		/* unable to read net driver */
#define EXIT_MAKEROM_INVTYPE	0x31		/* invalid driver type */
#define EXIT_MAKEROM_ARGSIZE	0x32		/* DOS program arg too large */
#define EXIT_MAKEROM_DOSSIZE	0x33		/* DOS program too large */
#define EXIT_MAKEROM_PROTINI	0x34		/* error reading protocol.ini */
#define EXIT_MAKEROM_UNDISIZE	0x35		/* UNDI driver too large */
#define EXIT_MAKEROM_DRVEOF	0x36		/* unexpected end of net I/F */
#define EXIT_MAKEROM_IFFND	0x37		/* no driver interfaces found */
#define EXIT_MAKEROM_PISIZE	0x38		/* PROTOCOL.INI img too large */
#define EXIT_MAKEROM_INVPNPID	0x39		/* invalid PnP ID */
#define EXIT_MAKEROM_PROGCOMP	0x3A		/* DOS program compressed */
#define EXIT_MAKEROM_MD5FILE	0x3B		/* unable to read MD5 file */
#define EXIT_MAKEROM_NETSIZE	0x3C		/* network driver too large */
#define EXIT_MAKEROM_DRVDB	0x3D		/* error accessing driver db */
#define EXIT_MAKEROM_INSTDRV	0x3E		/* error installing driver */

#define EXIT_LINUX_KERNEOF	0x41		/* unexpected end of kernel */
#define EXIT_LINUX_INVKERN	0x42		/* invalid kernel image */
#define EXIT_LINUX_INVSETUP	0x43		/* invalid kernel setup */
#define EXIT_LINUX_KERNSIZE	0x44		/* kernel too large */
#define EXIT_LINUX_CMDLSIZE	0x45		/* command line size */
#define EXIT_LINUX_NORD		0x46		/* no ramdisk specified */
#define EXIT_LINUX_KERNOPEN	0x47		/* unable to open kernel file */
#define EXIT_LINUX_IMGCREATE	0x48		/* unable to create image */
#define EXIT_LINUX_RDOPEN	0x49		/* unable to open ramdisk */
#define EXIT_LINUX_INVETH	0x4B		/* invalid ethernet device */
#define EXIT_LINUX_RDLOC	0x4C		/* invalid ramdisk location */
#define EXIT_LINUX_VGAMODE	0x4D		/* invalid VGA mode */
#define EXIT_LINUX_INVRDDEV	0x4E		/* invalid ramdisk device */
#define EXIT_LINUX_INVCLNTNAME	0x4F		/* invalid client name */
#define EXIT_LINUX_INVPROTO	0x50		/* invalid protocol name */

#define EXIT_DOS_RDREAD		0x61		/* error reading ramdisk */
#define EXIT_DOS_RDEOF		0x62		/* unexpected end of ramdisk */
#define EXIT_DOS_NOBOOT		0x63		/* ramdisk not bootable */
#define EXIT_DOS_NODOS		0x64		/* ramdisk not DOS image */
#define EXIT_DOS_INVFS		0x65		/* invalid DOS filesystem */
#define EXIT_DOS_SECTSIZE	0x66		/* invalid sector size */
#define EXIT_DOS_INVSIZE	0x67		/* invalid DOS fs size */
#define EXIT_DOS_FATNUM		0x68		/* invalid FAT number */
#define EXIT_DOS_INVFAT		0x69		/* invalid FAT size */
#define EXIT_DOS_RDSIZE		0x6A		/* invalid ramdisk size */
#define EXIT_DOS_IMGCREATE	0x6B		/* unable to create image */
#define EXIT_DOS_DOUBLEFILE	0x6C		/* two files with same name */
#define EXIT_DOS_INVSYS		0x6D		/* DOS system file missing */
#define EXIT_DOS_RDSPACE	0x6E		/* not enough ramdisk space */
#define EXIT_DOS_RDSTAT		0x6F		/* unable to stat ramdisk */
#define EXIT_DOS_RDOPEN		0x70		/* unable to open ramdisk */
#define EXIT_DOS_INVRD		0x71		/* ramdisk no file or dir */
#define EXIT_DOS_BOOTSECT	0x72		/* invalid DOS boot sector */

#define EXIT_MGL_CODESIZE	0x81		/* code size too large */
#define EXIT_MGL_CONSTSIZE	0x82		/* const data size too large */
#define EXIT_MGL_COMPERRS	0x83		/* compile errors */
#define EXIT_MGL_NOSTART	0x84		/* no start screen defined */
#define EXIT_MGL_PROGOPEN	0x85		/* unable to open prog file */
#define EXIT_MGL_IMGCREATE	0x86		/* error creating output file */
#define EXIT_MGL_LEX		0x87		/* error in input lexer */
#define EXIT_MGL_OVERFLOW	0x88		/* overflow of some data */
#define EXIT_MGL_RUNTIME	0x89		/* invalid runtime module */
#define EXIT_MGL_LOADER		0x8A		/* invalid runtime loader */
#define EXIT_MGL_OUTNAME	0x8B		/* invalid output file name */


#endif

