/*
 * exec.h  -  DOS structures related to program execution
 *
 * Copyright (C) 2003-2007 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: exec.h,v 1.6 2007/01/06 18:30:52 gkminix Exp $
 */

#ifndef DOS_EXEC_H
#define DOS_EXEC_H


/*
 * Check the compile system and turn structure packing on
 */
#include <compiler.h>
#include <pack.h>



/*
 **************************************************************************
 *
 * Definition of Program Segment Prefix (PSP)
 *
 * The PSP only gets defined for assembly sources - there is no need to
 * use it in C sources.
 */
#ifdef _ASSEMBLY_

			.struct	0

psp_exit:		.struct	.+2	/* opcode for INT 0x20 */
psp_endmem:		.struct	.+2	/* first allocatable seg after prog */
			.struct	.+1	/* reserved */
psp_dispatch:		.struct	.+5	/* opcode for function dispatch call */
psp_int22:		.struct	.+4	/* saved interrupt 0x22 vector */
psp_int23:		.struct	.+4	/* saved interrupt 0x23 vector */
psp_int24:		.struct	.+4	/* saved interrupt 0x24 vector */
psp_parent:		.struct	.+2	/* segment of parent PSP */
psp_handles:		.struct	.+20	/* process file handles */
psp_env:		.struct	.+2	/* segment of program environment */
psp_oldstack:		.struct	.+4	/* stack pointer of parent */
psp_numhndl:		.struct	.+2	/* number of file handles */
psp_ofshndl:		.struct	.+2	/* offset of file handle table */
psp_seghndl:		.struct	.+2	/* segment of file handle table */
			.struct	.+24	/* reserved */
psp_request:		.struct	.+3	/* INT 0x21 / LRET instructions */
			.struct	.+9	/* reserved */
psp_fcb1:		.struct	.+16	/* first part of FCB 1 */
psp_fcb2:		.struct	.+16	/* first part of FCB 2 */
			.struct	.+4	/* reserved */
psp_cmdlsize:		.struct	.+1	/* length of command line */
psp_cmdl:		.struct	.+127	/* command line */

#endif


/* Max. length of command line without the trailing CHR_CR and NULL */
#define PSP_MAXCMDL	125


/* Size of PSP with full command line */
#define PSP_SIZE	256



/*
 **************************************************************************
 *
 * Definition of executable file header
 */

/*
 * COM-type program definitions. The magic cookie is only used by the bootrom
 * network driver, and is a pseudo-header added by the binary patch program.
 */
#define	COM_MAGIC	0x4B47		/* magic cookie for COM prog images */
#define COM_STACK_PARA	64		/* min. number of para. for COM stack */


/*
 * EXE-type program definitions.
 */
#define	EXE_MAGIC	0x5A4D		/* magic cookie for EXE prog images */
#define	EXE_SECTSIZE	512		/* size of program sectors in EXE */


/*
 * Minimum and maximum amount of memory required to load a DOS program
 */
#define MIN_PROG_PARA	80
#define MAX_PROG_PARA	4095



/*
 * Definition of EXE file header
 */
#ifndef _ASSEMBLY_

struct exehdr {
	__u16	sig;			/* EXE file signature */
	__u16	lastsect;		/* number of bytes in last sector */
	__u16	fsize;			/* number of sectors in program */
	__u16	relocnum;		/* number of reloc table entries */
	__u16	headsize;		/* size of header in paragraphs */
	__u16	minpara;		/* min. no of paragraphs required */
	__u16	maxpara;		/* max. no of paragraphs required */
	__u16	ss;			/* stack seg (offset to prog start) */
	__u16	sp;			/* stack pointer */
	__u16	checksum;		/* checksum of file header */
	__u16	ip;			/* start address of program */
	__u16	cs;			/* start seg (offset to prog start) */
	__u16	reloctab;		/* offset to relocation table */
	__u16	overlay;		/* overlay number */
} PACKED;

#else

			.struct	0

exehdr_sig:		.struct	.+2	/* EXE file signature */
exehdr_lastseg:		.struct	.+2	/* number of bytes in last sector */
exehdr_fsize:		.struct	.+2	/* number of sectors in program */
exehdr_relocnum:	.struct	.+2	/* number of reloc table entries */
exehdr_headsize:	.struct	.+2	/* size of header in paragraphs */
exehdr_minpara:		.struct	.+2	/* min. no of paragraphs required */
exehdr_maxpara:		.struct	.+2	/* max. no of paragraphs required */
exehdr_ss:		.struct	.+2	/* stack seg (offset to prog start) */
exehdr_sp:		.struct	.+2	/* stack pointer */
exehdr_checksum:	.struct	.+2	/* checksum of file header */
exehdr_ip:		.struct	.+2	/* start address of program */
exehdr_cs:		.struct	.+2	/* start seg (offset to prog start) */
exehdr_reloctab:	.struct	.+2	/* offset to relocation table */
exehdr_overlay:		.struct	.+2	/* overlay number */

#endif



/*
 * Restore all definitions for data structure packing
 */
#include <unpack.h>

#endif

