/*
 * compiler.h  -  Define the type of compiler used for a source file
 *
 * Copyright (C) 2003-2007 Gero Kuhlmann   <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: compiler.h,v 1.5 2007/01/06 18:30:52 gkminix Exp $
 */


/*
 * Many header files will be included into different source file types,
 * which all have to be cared for specially:
 *
 *   - host C compiler:   we must be sure to include all header files which
 *                        are required to define the target systems data types,
 *                        and all structures have to be packed
 *   - target C compiler: all header files for defining special data types have
 *                        to be included as well. However, the target C compiler
 *                        always packs all structures.
 *   - target assembler:  the data structures have to be defined as structure
 *                        offsets
 *
 * Define the allowed system types:
 */
#if !defined(COMPILE_SYSTEM)
# define COMPILER_UNKNOWN	0
# define COMPILER_HOST		1
# define COMPILER_TARGET_GCC	2
# define COMPILER_TARGET_GAS	3

# define COMPILE_SYSTEM	COMPILER_UNKNOWN
#endif



/*
 * Check if we are using the host compiler. For all target source files, the
 * Makefiles define the _TARGET_ preprocessor token. If this is not defined,
 * and neither the _BOOTROM_ or __BCC__ tokens are defined, we can be pretty
 * sure that we are compiling a host-based source file.
 */
#if COMPILE_SYSTEM == COMPILER_UNKNOWN
# if !defined(_TARGET_) && !defined(__BCC__) && !defined(_BOOTROM_)
#  undef COMPILE_SYSTEM
#  define COMPILE_SYSTEM COMPILER_HOST
# endif
#endif



/*
 * If we are using GCC to produce a target file, _TARGET_ is defined by the
 * Makefiles, and __GNUC__ is defined by the preprocessor.
 */
#if COMPILE_SYSTEM == COMPILER_UNKNOWN
# if defined(_TARGET_) && defined(__GNUC__) && !defined(_ASSEMBLY_)
#  undef COMPILE_SYSTEM
#  define COMPILE_SYSTEM COMPILER_TARGET_GCC
# endif
#endif



/*
 * When using GAS to assemble target assembler source files, _ASSEMBLY_ has
 * been defined by the Makefiles.
 */
#if COMPILE_SYSTEM == COMPILER_UNKNOWN
# if defined(_TARGET_) && defined(_ASSEMBLY_) && !defined(_USE_ASSEMBLER)
#  undef COMPILE_SYSTEM
#  define COMPILE_SYSTEM COMPILER_TARGET_GAS
# endif
#endif



/*
 * Check if we are compiling in a valid environment
 */
#if COMPILE_SYSTEM == COMPILER_UNKNOWN
# error Unknown compiler environment
#endif



/*
 * Check that we included a valid file for the current compile system
 */
#if defined(GCC_INCLUDE) && defined(GAS_INCLUDE)
# undef GCC_INCLUDE
#endif

#if defined(GCC_INCLUDE)
# if COMPILE_SYSTEM == COMPILER_HOST
#  error Unable to include target GCC file into host source
# endif
# if COMPILE_SYSTEM == COMPILER_TARGET_GAS
#  error Unable to include target GCC file into assembly source
# endif
# undef GCC_INCLUDE
#endif

#if defined(GAS_INCLUDE)
# if COMPILE_SYSTEM == COMPILER_HOST
#  error Unable to include target assembly file into host source
# endif
# if COMPILE_SYSTEM == COMPILER_TARGET_GCC
#  error Unable to include target assembly file into GCC source
# endif
# undef GAS_INCLUDE
#endif



/*
 * Include common header files according to the type of compile system
 */
#if COMPILE_SYSTEM == COMPILER_HOST
# ifndef NEED_BINARY
#  define NEED_BINARY 1
# endif
# ifndef COMMON_H
#  include <common.h>
# endif
#endif

#if COMPILE_SYSTEM == COMPILER_TARGET_GCC
# ifndef COMMON_H86
#  include <common.h86>
# endif
# ifdef PACKED
#  undef PACKED
# endif
# define PACKED
#endif

#if COMPILE_SYSTEM == COMPILER_TARGET_GAS
# ifndef COMMON_I86
#  include <common.i86>
# endif
#endif

