.\" @(#)nbdbtool.8
.\"
.\" Copyright (C) 2006-2007 Gero Kuhlmann   <gero@gkminix.han.de>
.\"
.\"  This program is free software; you can redistribute it and/or modify
.\"  it under the terms of the GNU General Public License as published by
.\"  the Free Software Foundation; either version 2 of the License, or
.\"  any later version.
.\"
.\"  This program is distributed in the hope that it will be useful,
.\"  but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"  GNU General Public License for more details.
.\"
.\"  You should have received a copy of the GNU General Public License
.\"  along with this program; if not, write to the Free Software
.\"  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\"
.\" $Id: nbdbtool.man,v 1.5 2007/01/06 18:30:50 gkminix Exp $
.TH NBDBTOOL 8 "07 Sep 2006"
.SH NAME
nbdbtool - Netboot database management tool

.SH SYNOPSIS
.LP
.B nbdbtool
[OPTIONS]

.SH DESCRIPTION
.B nbdbtool
is a simple program to view and delete entries in the 
netboot systems database. Each utility program in the
netboot package is able to write it's parameters into
this database, and with this tool it is possible to
show a list of these database entries, to print an
individual database entry or to delete an entry.

.SH OPTIONS
.TP
.B -C, --config-file FILE
Specifies the pathname of the configuration file. If this option is not
given, the value of the
.SM NETBOOT_CONFIG
environment variable or a compiled-in default will be used.
.TP
.B -c, --clone FILE|DBSPEC
This action clones all records from a database file or database 
specification into the systems database.
.TP
.B -D, --database FILE|DBSPEC
Pathname of database file (or database specification) on which
the program is to act on.
If this option is not given, the value of the
.SM NETBOOT_DATABASE
environment variable or a compiled-in default will be used.
See the netboot(5) man page for a further explanation of
different ways to specify a database.
.TP
.B -d, --delete NAME
Name of database entry to delete 
.TP
.B -F, --logfile
Name of log file to write debugging output to. The default is to
print all verbose output to stdout.
.TP
.B -f, --filter FILTER
Print a list of database entries based on a filter string. This
filter string can contain wildcard characters. A '*' character
matches any number of characters in the database entry name, and
a '?' character matches exactly one character in the database
entry name. If the filter string contains any of these wildcard
characters, the whole string has to be enclosed into single
quotes on a standard UNIX shell so that the wildcard characters 
don't get interpreted by the shell. The database record list
gets printed onto standard output.
.TP
.B -H, --home-dir
Specifies the home directory. If this command line option is not
given, either the
.B homedir
configuration file parameter or the current user's home directory
will be used.
.TP
.B -h, --help
Print short usage information.
.TP
.B -L, --libdir DIR
Pathname of the non-shared-data directory. If this option is not given, the
value of the 
.SM NETBOOT_LIB
environment variable or a compiled-in default will be used.
.TP
.B -l, --list
Print all record names contained within the systems database onto 
standard output.
.TP
.B -N, --datadir DIR
Pathname of the shared-data directory. If this option is not given, the value
of the 
.SM NETBOOT_DATA
environment variable or a compiled-in default will be used.
.TP
.B -o, --outfile FILE
This option will print the output of the 
.B --print
or 
.B --list
action into a file rather than on stdout.
.TP
.B -p, --print NAME
Print the contents of a specific database record. This will print
all values contained in this record onto standard output.
.TP
.B -q, --quiet
Don't print any error messages. If an error occurred, it is possible
to find out about the cause of the error by inspecting the error code 
returned by 
.BR nbdbtool .
.TP
.B -r, --raw
With the print action, this option prints all parameters as they appear
in the database, even if they are duplicate or empty.
.TP
.B -v, --version
Print version information.
.TP
.B -x, --verbose
Verbose output to let you know what 
.B nbdbtool
is doing. Each
.B -x
increases the verbosity level.

.SH DATABASE RECORD NAMES
The systems database can contain various records, with each record
giving definitions for a specific 
.B netboot
program and client system. The record names are constructed like this:
<program name>:<system name>. The same record name can appear multiple
times in a database. Usually, when a netboot program uses such a record
name, it scans all entries and uses the last one found within the database.
This is also the way the 
.B --print
option works. However, the
.B --delete
option will delete all records for a given record name.

.SH ENVIRONMENT VARIABLES
See the netboot(5) man page for a description of all environment
variables used by 
.BR nbdbtool .

.SH BUGS
None known yet 

.SH SEE ALSO
netboot(5), netboot.config(5)

.SH AUTHOR
.B nbdbtool
was written by 
.SM Gero Kuhlmann <gero@gkminix.han.de>.

