(***********************************************************************
   Walk Memory Control Block chain                Version 1.00

   Demonstration of Environ.TPU (and other stuff too, I guess).
   Written Jan 17 1996 Robert B. Clark <rclark@iquest.net>

   Donated to the public domain; inclusion in SWAG freely permitted.

   Usage: WALKMCB [evar] [new_value]
   =================================
   If 'evar' is not specified, WALKMCB simply demonstrates how to walk
   the MCB chain.

   If 'evar' _is_ specified, WALKMCB displays the master environment
   value of 'evar' and sets the current value of 'evar' to 'new_value.'
   It then demonstrates the shell to DOS function Shell() so that you
   may verify the changed environment variable by typing SET at the
   shelled command line.

   Note that the 'evar' argument IS case-sensitive, to accomodate the
   infamous "windir" evar Microsoft foisted upon us.
   ********************************************************************)

Program WalkMCB;

{$M 8096,0,1024}          { Stack, min heap, max heap}
{$DEFINE DispMCB}         { Display MCBs while walking }

Uses Dos, Environ
{$IFDEF UseLib}   ,Convert,Global   { Hex conversions, various }
{$ELSE}           ,Crt
{$ENDIF}          ;

CONST  CREDIT      = ' v1.00 Written Jan 17 1996 Robert B. Clark';
(**********************************************************************)
{$IFNDEF UseLib}     { Selected functions from personal units }

(* KeyBd.TPU *)

PROCEDURE ClearKeybd;
inline($FA/             { cli               ; Disable interrupts     }
       $33/$C0/         { xor ax,ax         ; Head/tail keybuf ptrs  }
       $8E/$C0/         { mov es,ax         ; at 40:001A and 40:001C }
       $26/$A0/$1A/$04/ { es mov al,b[041a] ; Head ptr in AL         }
       $26/$A2/$1C/$04/ { es mov b[041c],al ; Now tail=head          }
       $FB);            { sti               ; Reenable interrupts    }
{ClearKeybd}

(* Convert.TPU *)

FUNCTION HexByte(b:byte):string;
{ Converts decimal to hexadecimal byte string }
const hexDigits: array [0..15] of char = '0123456789ABCDEF';
begin
  HexByte:=hexDigits[b shr 4] + hexDigits[b and $F]
end; {HexByte}


FUNCTION HexWord(w:word): string;
{ Converts decimal to hexadecimal word string }
begin
  HexWord:=HexByte(hi(w)) + HexByte(lo(w))
end; {HexWord}


FUNCTION HexDWord(w:longint): string;
{ Converts decimal to hexadecimal doubleword string. }
begin
  if (w<0) then w:=w-$10000;
  HexDWord:=HexWord(w div 65536)  + HexWord(w mod 65536)
end; {HexDWord}

(* Global.TPU *)

PROCEDURE SetRedirect(var infile,outfile: string);
{ Sets Input/Output to DOS STDIN/OUT routines. }
begin
   Assign(Output,outFile);        { Set up for STDOUT output }
   Rewrite(Output);
   Assign(Input,inFile);          { Set up for STDIN input }
   Reset(Input)
end; {SetRedirect}


FUNCTION CurSize:word;
{ Returns current size of cursor. The high byte is the beginning scan
  line; the low byte is the ending scan line. }
var regs: Registers;

begin
   with regs do           { Get current cursor size }
   begin
      AH:=$03;            { Want BIOS Int 10h/3, Read Cursor Pos/Size }
      BH:=$00;            { Video page number }
      Intr($10,regs);     { BH=page #, CX=beg/end scan line, DX=row/col}
      CurSize:=CX
   end;
end; {CurSize}


PROCEDURE Cursor_OnOff(on:boolean);
{ Toggles the cursor on and off. }
var regs: Registers;
    sbeg:byte;

begin
  sbeg:=hi(CurSize);                 { Get starting scan row }
  if (on) then sbeg:=sbeg and $df    { Toggle bit 5 }
  else sbeg:=sbeg or $20;

  with regs do
  begin
    AH:=$01;                  { Want BIOS Int 10h/1 Set cursor size }
    CH:=sbeg;                 { Beginning cursor scan line }
    CL:=lo(CurSize);          { Ending cursor scan line }
    Intr($10,regs)
  end;
end; {Cursor_OnOff}


PROCEDURE Pause;
{ Simply waits for the user to press [Enter] while displaying a
  spinning cursor. Invalid keypresses cause a tone to sound.
  The keyboard buffer is cleared upon entry and exit. }

   procedure Tone(hz,duration:word);
   { Produces tone at 'hz' frequency and of 'duration' ms }
   begin
      Sound(hz); Delay(duration); NoSound
   end; {Tone}

const cursor: array[0..6] of char = '-\|/-\|';
var   okChar: boolean;
           c: char;
       i,x,y: shortint;

begin
   Cursor_OnOff(false);
   write(#10#13'Press Enter'#17#217' to continue... ');
   x:=WhereX; y:=WhereY;
   ClearKeybd; okChar:=false;
   repeat
      inc(i); i:=i mod 7;
      write(cursor[i]); gotoxy(x,y);
      Delay(55);
      if KeyPressed then
      begin
         c:=ReadKey; if c=#0 then c:=ReadKey;  { Toss extended byte }
         if c=chr(13) then okChar:=true
         else Tone(2000,100)
      end;
   until okChar;
   gotoxy(1,y); ClrEol; gotoXY(1,y);
   ClearKeybd; Cursor_OnOff(true);
end; {Pause}

{$ENDIF}  (* End of unit functions from personal libs *)

(* ******************************************************************* *)
procedure DisplayMCB(mcb: MCBType; block_num: integer);
begin
   with mcb do
   begin
      writeln('MCB Block #',block_num:3,': Address ',HexWord(MCB_Seg),
         ':', HexWord(MCB_Ofs), '   Absolute: ',
         HexDWord(MCB_Seg*16+MCB_Ofs));
      write('   Block Type    : ',HexByte(blockID),'   (');
      if (blockID<>$4D) and (blockID<>$5A) then
         writeln('ERROR)')
      else
         writeln(chr(blockID),')');
      write('   PSP of Owner  : ',HexWord(ownerPSP));
      if ownerPSP=0 then      write(' (free)')
      else if ownerPSP=8 then write(' (DOS) ')
      else write('       ');
      writeln(' Owner: ',ownerName);   { Garbage if DOS <4.0 }
      writeln('   PSP PARENT_ID : ',HexWord(parentPSP));
      writeln('   ENVSEG        : ',HexWord(MemW[ownerPSP:$002c]));
      writeln('   Size of MCB   : ',HexWord(blockSize),' paragraphs (',
         blockSize*16,' bytes).');
      writeln
   end;
end; {DisplayMCB}


procedure WalkChain(var mcb: MCBType);
{ Walks the MCB chain until block type is no longer 4D (M).}
var last,root : boolean;
    offset    : longint;
    block     : integer;
begin
   InitMCBType(mcb);
   block:=0;
   repeat
      ReadMCB(mcb,last,root);
      Inc(block);
{$IFDEF DispMCB}
      DisplayMCB(mcb,block);
{$ENDIF}
      if not last then
      begin
         offset := mcb.MCB_Ofs+16+(mcb.BlockSize*16);
         mcb.MCB_Ofs := offset mod $10000;
         mcb.MCB_Seg := mcb.MCB_Seg + (offset div $10000)
      end;
   until last
end; {WalkChain}


procedure Header(walk:boolean);
begin
   writeln;
   if walk then
   begin
      writeln('WALK MEMORY CONTROL BLOCK CHAIN');
      writeln('===============================')
   end
   else begin
      writeln('ENVIRONMENT MANIPULATION AND THE DOS SHELL');
      writeln('===========================================')
   end;

   writeln('Current PSP (PrefixSeg) is ',HexWord(PrefixSeg));
   writeln('The parent PSP segment  is ',HexWord(MemW[prefixSeg:$0016]));
   writeln('The environment segment is ',HexWord(CURRENT_ENVSEG));
   writeln;
end; {Header}


procedure GetParms(var p1,p2: evarType);
{ Get command line parameters 1 and 2 }
var i:integer;
begin
   p1:=''; p2:='';
   p1:=ParamStr(1);
   i:=2;
   while ParamStr(i) <> '' do    { Param 2 is concatenated p2, p3, ... }
   begin
      p2:=p2 + ParamStr(i);
      if ParamStr(i+1) <> '' then p2:=p2+' ';
      Inc(i)
   end;
end;
(**************************************************************************)
var
    mcb : MCBType;
    walk: boolean;
    x   : integer;
    evar,value: evarType;
    prompt: evarType;
    infile,outfile: string;

begin {main}
   infile:=''; outfile:='';
   SetRedirect(infile,outfile);  { Use STDIN/OUT }
   GetParms(evar,value);
   prompt:='$e[1m['+FNStrip(PROGRAMNAME,2)+'] $e[0m$p$g';
   walk:=evar='';
   Header(walk);

   if walk then
   begin
      WalkChain(mcb);
      writeln('The last MCB in the chain is at ',
         HexWord(mcb.MCB_Seg),':', HexWord(mcb.MCB_Ofs),'.');
   end
   else begin
      writeln('The master (root) Memory Control Block is at ',
         HexWord(MASTER_MCB.MCB_Seg),':',
         HexWord(MASTER_MCB.MCB_Ofs),'.');
      writeln('The root environment is at ',HexWord(MASTER_ENVSEG),
         ':0000 and its maximum size is ',MaxEnvSize(MASTER_ENVSEG),
         ' bytes.');
      writeln('The master environment size is ',
         EnvSize(MASTER_ENVSEG),' bytes.');
      writeln('Current environment (',HexWord(CURRENT_ENVSEG),
         ') size is ',EnvSize(CURRENT_ENVSEG),' bytes.');

      writeln('Master  : ',evar,'="', GetEnv(evar,MASTER_ENVSEG),'"');
      writeln('Current : ',evar,'="', GetEnv(evar,CURRENT_ENVSEG),'"');
      if not PutEnv(evar,value,CURRENT_ENVSEG) then
         writeln(#10#13#7'*** Insufficient environment space!');
      writeln('After   : ',evar,'="', GetEnv(evar,CURRENT_ENVSEG),'"');

      Pause;
      x:=Shell(''); {prompt);}   { Try both }
      writeln; writeln('Shell() returned DOS code ',x)
   end;
   writeln(FNStrip(PROGRAMNAME,2),CREDIT)
end.
