/* XHDBench Copyright (C) 1998 Jan Fricke & Alexander Lang.

XHDBench is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

XHDBench is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */

#ifndef BENCHWIDGET_H
#define BENCHWIDGET_H

#include <qbttngrp.h>
#include <qlabel.h>
#include <qpushbt.h>
#include <qwidget.h>

#include "benchbarfield.hh"
#include "benchlistbox.hh"

#define APPNAME "XHDBench"
#define VERSION "0.5.3"

class BenchWidget : public QWidget
{
  Q_OBJECT

public:
  BenchWidget( QWidget *parent=0, const char *name=0 );

public slots:
  void add();
  void info();
  void startStop();
  void transferSizeChanged( int );
  void transferTypeChanged( int );

protected:
  void resizeEvent( QResizeEvent * );
  void timerEvent( QTimerEvent * );

private:
  BenchBarField *benchBarField;
  QFrame *trennLinie;
  BenchListBox *benchListBox;
  QLabel *labelBenchListBox;
  QButtonGroup *bgTransferSize, *bgTransferType;
  QPushButton *btStartStop, *btAdd, *btInfo, *btQuit;
};

#endif // BENCHWIDGET_H
