/* XHDBench Copyright (C) 1998 Jan Fricke & Alexander Lang.

XHDBench is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

XHDBench is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */

#include <string.h>
#include <unistd.h>

#include <qapp.h>
#include <qdialog.h>
#include <qlined.h>
#include <qmsgbox.h>
#include <qradiobt.h>

#include "bench.hh"
#include "benchwidget.hh"

//===========================================================================

BenchWidget::BenchWidget( QWidget *parent, const char *name )
    : QWidget( parent, name )
{
  char* transfersizeNames[] = 
  {"2K", "4K", "8K", "12K", "16K", "24K", "32K", "48K", "64K", NULL};
  char* transfertypeNames[] = 
  {"Random I/O", "Sequential I/O", NULL};
  char hostname[256] = {};
  char* s;
  int i;
  QFontMetrics fm = fontMetrics();

  //-------------------------------------------------------------------------

  gethostname(hostname, sizeof(hostname) - 1);
  setCaption(QString(APPNAME" "VERSION" @") + QString(hostname));

  //-------------------------------------------------------------------------

  benchBarField = new BenchBarField( this, "benchBarField" );

  //-------------------------------------------------------------------------

  trennLinie = new QFrame( this );
  trennLinie->setFrameStyle( QFrame::Panel | QFrame::Sunken );
  trennLinie->setLineWidth( 1 );

  //-------------------------------------------------------------------------

  benchListBox = new BenchListBox( this, "benchListBox" );

  //-------------------------------------------------------------------------

  labelBenchListBox = new QLabel( benchListBox, 
                                  "Select devices to include in benchmark:",
                                  this );
  labelBenchListBox->resize(fm.width(labelBenchListBox->text()), fm.ascent());

  //-------------------------------------------------------------------------

  bgTransferSize = new QButtonGroup( "Transfer Size", this, 
                                     "bgTransferSize" );
  bgTransferSize->resize(250, 100);
  for ( i=0; (s=transfersizeNames[i]) != NULL; i++ ) {
    QRadioButton *rb = new QRadioButton( s, bgTransferSize );
    rb->setGeometry( (i/3)*80 + 20, (i%3)*25+20, 50, 20 );
    if ( i == 8 ) rb->setChecked( TRUE );
  }
  connect( bgTransferSize, SIGNAL(clicked(int)), 
           SLOT(transferSizeChanged(int)) );

  //-------------------------------------------------------------------------

  bgTransferType = new QButtonGroup( "Transfer Type", this, 
                                     "bgTransferType" );
  bgTransferType->resize(250, 100);
  for ( i=0; (s=transfertypeNames[i]) != NULL; i++ ) {
    QRadioButton *rb = new QRadioButton( s, bgTransferType );
    rb->setGeometry( (i/3)*80 + 20, (i%3)*25+20, 120, 20 );
    if ( i == 1 ) rb->setChecked( TRUE );
  }
  connect( bgTransferType, SIGNAL(clicked(int)), 
           SLOT(transferTypeChanged(int)) );

  //-------------------------------------------------------------------------

  btStartStop = new QPushButton( "&Start", this, "btStartStop" );
  btStartStop->resize(70, 25);
  connect( btStartStop, SIGNAL(clicked()), SLOT(startStop()) );
  btStartStop->setEnabled( FALSE );

  btAdd = new QPushButton( "&Add", this, "btAdd" );
  btAdd->resize(70, 25);
  connect( btAdd, SIGNAL(clicked()), SLOT(add()) );
  btAdd->setEnabled( FALSE );

  btInfo = new QPushButton( "&Info", this, "btInfo" );
  btInfo->resize(70, 25);
  connect( btInfo, SIGNAL(clicked()), SLOT(info()) );

  btQuit = new QPushButton( "&Quit", this, "btQuit" );
  btQuit->resize(70, 25);
  connect( btQuit, SIGNAL(clicked()), qApp, SLOT(quit()) );

  //-------------------------------------------------------------------------

  startTimer(100);
}

//===========================================================================

class AddDialog : public QDialog {
//  Q_OBJECT

public:
  AddDialog( QWidget *parent, const char *name );
  QLineEdit *newDevice;
};

AddDialog::AddDialog( QWidget *parent, const char *name )
    : QDialog( parent, name, TRUE )
{
  QPushButton *ok, *cancel;
  QFontMetrics fm = fontMetrics();

  setCaption("add a device");
  resize(300, 100);

  newDevice = new QLineEdit( this, "newDevice" );
  newDevice->setGeometry( 25, 20, width()-50, fm.lineSpacing() + 10 );
  newDevice->setMaxLength( 255 );
  newDevice->setText( "/dev/" );

  ok = new QPushButton( "&Ok", this );
  ok->setGeometry( width()-180, height()-35, 70, 25 );
  ok->setDefault(TRUE);
  connect( ok, SIGNAL(clicked()), SLOT(accept()) );
  cancel = new QPushButton( "&Cancel", this );
  cancel->setGeometry( width()-90, height()-35, 70, 25 );
  connect( cancel, SIGNAL(clicked()), SLOT(reject()) );

  newDevice->setFocus();
}

void BenchWidget::add()
{
  AddDialog addDialog( this, "addDialog");

  if (addDialog.exec())
  {
    insertdevice((char *)addDialog.newDevice->text());
    benchListBox->insertItem( anz_geraete-1 );
  }
}

//===========================================================================

void BenchWidget::info()
{
  QMessageBox::information( this, APPNAME,
                            "Copyright (c) 1998 by\n\n"
                            "Jan Fricke (fricke@uni-greifswald.de)\n\n"
                            "Alexander Lang (lang@mueritz-comp.de)" );
}

//===========================================================================

void BenchWidget::startStop()
{
  if (!strcmp(btStartStop->text(), "&Start"))
  {
    if (benchListBox->start())
      btStartStop->setText("&Stop");
  }
  else
  {
    benchListBox->stop();
    btStartStop->setText("&Start");
  }
}

//===========================================================================

void BenchWidget::transferSizeChanged( int index )
{
  // printf("transferSizeChanged( %i )\n", index);
  switch (index)
  {
    case 0: blocksize =  2 * 1024; break;
    case 1: blocksize =  4 * 1024; break;
    case 2: blocksize =  8 * 1024; break;
    case 3: blocksize = 12 * 1024; break;
    case 4: blocksize = 16 * 1024; break;
    case 5: blocksize = 24 * 1024; break;
    case 6: blocksize = 32 * 1024; break;
    case 7: blocksize = 48 * 1024; break;
    case 8: blocksize = 64 * 1024; break;
  }
}

//===========================================================================

void BenchWidget::transferTypeChanged( int index )
{
  switch (index)
  {
    case 0: random_read = TRUE; break;
    case 1: random_read = FALSE; break;
  }
}

//===========================================================================

void BenchWidget::resizeEvent( QResizeEvent * )
{
  int width_h, space, y;

  width_h = btStartStop->width();
  space = (width() - 4*width_h) / 5;
  y = height() - btStartStop->height() - 10;
  btStartStop->move( space, y );
  btAdd->move( 2*space + width_h , y );
  btInfo->move( 3*space + 2*width_h , y );
  btQuit->move( 4*space + 3*width_h , y );
  //-------------------------------------------------------------------------
  width_h = (width()-30) / 2;
  bgTransferSize->setGeometry(10, btQuit->y() - 10 - bgTransferSize->height(),
                              width_h, 100);
  bgTransferType->setGeometry(width_h + 20, bgTransferSize->y(),
                              width_h, 100);
  //-------------------------------------------------------------------------
  trennLinie->setGeometry(10, bgTransferSize->y()*3/5 - 1, width()-20, 2);
  //-------------------------------------------------------------------------
  benchListBox->setGeometry(10, trennLinie->y() + 20,
                            width()-20, 
                            bgTransferSize->y()-trennLinie->y()-25);
  labelBenchListBox->move(10, 
                          benchListBox->y() - 
                          labelBenchListBox->height() - 2);
  //-------------------------------------------------------------------------
  benchBarField->setGeometry(10, 10, width()-20, trennLinie->y() - 20);
}

//===========================================================================

void BenchWidget::timerEvent( QTimerEvent * qtimerevent )
{
  if (searchfinished == 1)
  {
    searchfinished = 2;
    benchListBox->insertItems();
    btStartStop->setEnabled( TRUE );
    btAdd->setEnabled( TRUE );
  }
  QApplication::sendEvent ( benchBarField, qtimerevent );
  QApplication::sendEvent ( benchListBox, qtimerevent );
}
