/* XHDBench Copyright (C) 1998 Jan Fricke & Alexander Lang.

XHDBench is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

XHDBench is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */

#include <stdlib.h>

#include <qmsgbox.h>
#include <qpainter.h>

#include "bench.hh"
#include "benchbarfield.hh"
#include "benchlistbox.hh"
#include "benchwidget.hh"

//===========================================================================

class BenchListBoxItem : public QListBoxItem
{
public:
  BenchListBoxItem( int device_nr_, int *showname_ );

protected:
  virtual void paint( QPainter * );
  //virtual const char* text () const;
  virtual int height( const QListBox * ) const;
  virtual int width( const QListBox * ) const;
  virtual const QPixmap *pixmap() { return &pm; }

private:
  QString txt;
  //QColor color;
  QPixmap pm;
  //Device *device;
  int device_nr;
  int *showname;
  void determineText();
};

BenchListBoxItem::BenchListBoxItem( int device_nr_, int *showname_ )
    : QListBoxItem()
{
  device_nr = device_nr_;
  showname = showname_;
  determineText();
}

void BenchListBoxItem::paint( QPainter *p )
{
  QFontMetrics fm = p->fontMetrics();

  pm.resize(fm.width( "xxxxxx" ), fm.lineSpacing()/2 );
  if (devices[device_nr].selected)
  {
    pm.fill(barcolors[device_nr%NR_COLORS]);
    p->drawPixmap( 3, (fm.lineSpacing() + 1 - pm.height()) / 2, pm );
  }

  determineText();
  p->drawText( pm.width() + 10, fm.ascent() + fm.leading()/2, text() );
}

int BenchListBoxItem::height(const QListBox *lb ) const
{
  return lb->fontMetrics().lineSpacing() + 1;
}

int BenchListBoxItem::width(const QListBox *lb ) const
{
  //determineText();
  return lb->fontMetrics().width( "xxxxxx" ) + 
    lb->fontMetrics().width( text() ) + 11;
}

void BenchListBoxItem::determineText()
{
  QString s = "", str_size;
//  char* name;
  unsigned int max_devicefilename_len = 0, max_devicedescription_len = 0,
    max_model_len = 0;
  long long size = devices[device_nr].groesse;
  int i;

  /*if (*showname) 
    name = devices[device_nr].bezeichnung; 
  else 
    name = devices[device_nr].name;*/

  for (i=0; i<anz_geraete; i++)
  {
    if (strlen(devices[i].devicefilename) > max_devicefilename_len)
      max_devicefilename_len = strlen(devices[i].devicefilename);
    if (strlen(devices[i].devicedescription) > max_devicedescription_len)
      max_devicedescription_len = strlen(devices[i].devicedescription);
    if (strlen(devices[i].model) > max_model_len)
      max_model_len = strlen(devices[i].model);
  }

  if (size > 1<<30)
    str_size.sprintf( "(%.2f GB)", (float)size/(1<<30) );
  else
    if (size > 1<<20)
      str_size.sprintf( "(%.2f MB)", (float)size/(1<<20) );
    else
      if (size > 1<<10)
        str_size.sprintf( "(%.2f kB)", (float)size/(1<<10) );
      else
        if (size > 0)
          str_size.sprintf( "(%.2f B)", (float)size );
        else
          str_size.sprintf( "" );

  /*s = QString(devices[device_nr].devicefilename).
    leftJustify( max_devicefilename_len + 3 );*/

  s = s.append(QString(devices[device_nr].devicedescription).
               leftJustify( max_devicedescription_len + 3 ));

  s = s.append(QString(devices[device_nr].model).
               leftJustify( max_model_len + 3 ));

  s = s.append(str_size);

  setText( s );
}

//===========================================================================

BenchListBox::BenchListBox( QWidget * parent=0, const char * name=0 )
    : QListBox( parent, name )
{
  shownames = TRUE;
  started = FALSE;
 
  QListBox::insertItem("looking for devices...");

  connect( this, SIGNAL(selected(int)), SLOT(itemSelected(int)) );
}

//void BenchListBox::insertItem( const char *name, long long size,
//                               QColor c = white )
void BenchListBox::insertItem( int device_nr )
{
  QListBox::insertItem( new BenchListBoxItem( device_nr, &shownames ));
}

void BenchListBox::insertItems()
{
  int i;

  clear();
  for ( i = 0; i < anz_geraete; i++ )
    insertItem( i );
}

int BenchListBox::start()
{
  int i;

  // Ist wenigstens ein Geraet ausgewaehlt?
  for (i=0; i<anz_geraete; i++)
    if (devices[i].selected) break;

  if (i == anz_geraete) // Nein!
  {
    QMessageBox::information( this, APPNAME,
                              "You have to select one device at least!");
  }
  else // Ja!
  {
    starte_geraete();
    started = TRUE;
  }

  return started;
}

void BenchListBox::stop()
{
  //int *keine_geraete;

  //keine_geraete = (int*)calloc(anz_geraete, sizeof(int));
  //starte_geraete(keine_geraete);
  stoppe_geraete();
  started = FALSE;
  //free(keine_geraete);
}

void BenchListBox::itemSelected( int index )
{
  if (searchfinished)
  {
    devices[index].selected = !devices[index].selected;
    updateItem( index );
    if (started) starte_geraete();
  }
}

void BenchListBox::timerEvent( QTimerEvent * )
{
  int i;

  if (started)
  {
    for (i=0; i<anz_geraete; i++)
    {
      if (devices[i].selected && !devices[i].laeuft)
      {
        devices[i].selected = FALSE;
        updateItem( i );
      }
      if (devices[i].groessegeaendert)
      {
        devices[i].groessegeaendert = FALSE;
        updateItem( i );
      }
    }
  }
}
