/* XHDBench Copyright (C) 1998 Jan Fricke & Alexander Lang.

XHDBench is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

XHDBench is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */

#ifndef BENCHBARFIELD_H
#define BENCHBARFIELD_H

#include <qcolor.h>
#include <qframe.h>
#include <qpainter.h>
#include <qpixmap.h>

#define NR_COLORS 15
extern QColor barcolors[];

class BenchBarField : public QFrame
{
public:
  BenchBarField( QWidget *parent=0, const char *name=0 );

protected:
  void paintEvent( QPaintEvent * );
  void timerEvent( QTimerEvent * );

private:
  QPixmap *image;
  //unsigned int *last_values;
  unsigned int last_scale;
  unsigned int calculate_scale(unsigned int max_durchsatz);
  void drawOneBenchBar(QPainter *p, int x, int y, int w, int h, QColor color);
  int values_have_changed();
};

#endif // BENCHBARFIELD_H
