/* XHDBench Copyright (C) 1998 Jan Fricke & Alexander Lang.

XHDBench is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

XHDBench is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */

#include <stdlib.h>

#include "benchbarfield.hh"
#include "bench.hh"
#include "xhdbench.xpm"

QColor barcolors[NR_COLORS] = {
  red, green, yellow, gray, blue, magenta, cyan, darkRed, darkGreen, 
  darkYellow, darkGray, darkBlue, darkMagenta, darkCyan, lightGray };

//===========================================================================

BenchBarField::BenchBarField( QWidget *parent=0, const char *name=0 )
    : QFrame( parent, name )
{
  setBackgroundColor( QColor( 0, 0, 0) );
  setFrameStyle( Panel | Sunken );
  setLineWidth( 2 );

  image = new QPixmap((const char **)xhdbench_xpm);

  //last_values = (unsigned int*)calloc(anz_geraete, sizeof(int));
  last_scale = 0;

  //startTimer( 100 );
};

//===========================================================================

void BenchBarField::paintEvent( QPaintEvent * e)
{
  QPainter p;
  QFontMetrics fm = fontMetrics();
  QString s;
  QPixmap pm( size() );
  int strwidth, strheight = fm.ascent(); //fm.height();
  int barheight = 10, barspace = 8;
  unsigned int max_durchsatz = 0;
  unsigned int sum_durchsatz = 0;
  unsigned int scale = 1000;
  int step;
  int i;
  
  //-------------------------------------------------------------------------

  QFrame::paintEvent(e);

  //-------------------------------------------------------------------------
  for (i=0; i<anz_geraete; i++)
  {
    if (devices[i].durchsatz > max_durchsatz)
      max_durchsatz = devices[i].durchsatz;
    sum_durchsatz += devices[i].durchsatz;
  }

  //-------------------------------------------------------------------------
  if (max_durchsatz > 0)
    scale = calculate_scale(max_durchsatz);
  last_scale = scale;

  //-------------------------------------------------------------------------
  step = (width() - fm.width("xxxxxxxxxxxxxx")) / 10;

  //-------------------------------------------------------------------------
  pm.resize(pm.width()-4, pm.height()-4);
  pm.fill( backgroundColor() );

  //-------------------------------------------------------------------------
  //p.begin( this );
  p.begin( &pm );

  //-------------------------------------------------------------------------
  p.setPen( gray ); 
  for (i=0; i<10; i++)
  {
    p.drawLine((i+1)*step, 5, (i+1)*step, height()-fm.ascent()-8);
  }

  //-------------------------------------------------------------------------
  p.drawPixmap((width()-image->width()-2)/2, (height()-image->height()-2)/2,
               *image);

  //-------------------------------------------------------------------------
  p.setPen( green );
  p.drawText( 2, height()-5 , "kB/s" );
  for (i=0; i<10; i++)
  {
    s.sprintf( "%i", scale*(i+1) );
    strwidth = fm.width(s);
    p.drawText( (i+1)*step - strwidth/2, height()-5 , s );
  }

  //-------------------------------------------------------------------------
  p.setPen( white );
  s.sprintf( "SUM %i", sum_durchsatz );
  p.drawText( width()-fm.width(s)-5 , height()-5 , s );
  
  //-------------------------------------------------------------------------
  for (i=0; i<anz_geraete; i++)
  {

    if (i*(barheight+barspace)+10+barheight > height()-fm.ascent()-8) 
      break;

    if (devices[i].durchsatz != 0)
    {
      drawOneBenchBar( &p,
                       2, i*(barheight+barspace) + 10,
                       devices[i].durchsatz * step / scale, barheight,
                       barcolors[i%NR_COLORS] );
      s.sprintf( "%i", devices[i].durchsatz );
      strwidth = fm.width(s);
      //p->setBrush( color );
      p.setPen( barcolors[i%NR_COLORS] );
      p.drawText ( width() - strwidth - 5, 
                   i*(barheight+barspace) + 10 + barheight - 
                   (barheight - strheight) / 2, 
                   s );
    }
  }
  
  //-------------------------------------------------------------------------
  p.end();
  bitBlt( this, 2, 2, &pm );
};

//===========================================================================

void BenchBarField::timerEvent( QTimerEvent * )
{
  int i;
  if (values_have_changed())
  {
    for (i=0; i<anz_geraete; i++)
      devices[i].last_value = devices[i].durchsatz;
    repaint(0);
  }
}

//===========================================================================

unsigned int BenchBarField::calculate_scale(unsigned int max_durchsatz)
{
  unsigned int scale = 1;
  int i = 1;

  while (max_durchsatz > scale * 10)
  {
    if (i==1) {scale *=2; i=2;} else
      if (i==2) {scale = scale/2*5; i=5;} else
      {scale = scale/5*10; i=1;}
  }

  if (max_durchsatz > scale * 8)
  //if ((last_scale*4 < max_durchsatz) && (max_durchsatz < last_scale*5))
  {
    if (last_scale > scale) scale = last_scale;
  }

  return scale;
}

//===========================================================================

void BenchBarField::drawOneBenchBar(QPainter *p, int x, int y, int w, int h,
                                    QColor color)
{
  QColor color_h;
  
  color_h = color.light(150);
  p->setBrush( color_h );
  p->setPen( color_h );
  p->drawRect( x, y, w-1, 1 );

  p->setBrush( color );
  p->setPen( color );
  p->drawPoint( x+w-1, y );
  p->drawRect( x, y+1, w-1, h-2 );

  color_h = color.dark(200);
  p->setBrush( color_h );
  p->setPen( color_h );
  p->drawRect( x+w-1, y+1, 1, h-2 );

  p->drawRect( x, y+h-1, w, 1 );
}

//===========================================================================

int BenchBarField::values_have_changed()
{
  int i;

  for (i=0; i<anz_geraete; i++)
  {
    if (devices[i].durchsatz != devices[i].last_value)
      return 1;
  }
  return 0;
}
