#include <fcntl.h>
#include <linux/cdrom.h>
#include <linux/hdreg.h>
#include <linux/fs.h>
#include <linux/fd.h>
#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>

#include "bench.hh"

#define ZEITGRENZE 1000000L

static pthread_t searcher;

int volatile anz_geraete = 0;
Device *devices = NULL;

int volatile blocksize = 65536;
int volatile random_read = (0==1);
int volatile searchfinished = (0==1);

static const char *numbers[] = {"First", "Second", "Third", "Fourth",
                               "Fifth", "Sixth", "Seventh", "Eighth", 0};
static const char *numnumbers[] = {"1st", "2nd", "3rd", "4th", "5th", "6th", "7th",
                                   "8hth", "9hth", "10hth", "11hth", "12hth", "13hth",
                                   "14hth", "15hth", "16hth", 0};
static char *proprienames[50] = 
{ NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  NULL, "Sony CDU-31A/CDU-33A", "GoldStar", "Optics Storage", "Sanyo", NULL, "Hitachi",
  NULL, NULL, "Mitsumi", "Sony CDU-535", "Matsushita", "Second Matsushita",
  "Third Matsushita", "Fourth Matsushita", "Aztech", "Philips LMS CM-205", NULL,
  "Philips LMS CM-206", NULL, NULL, NULL, NULL, NULL, NULL, NULL};


void insertgeraet(char *name, char *type, char *model,
                  int (*getblock2k)(int), long long groesse)
{
  devices = (Device *)realloc(devices, (anz_geraete + 1) * sizeof(Device));
  devices[anz_geraete].devicefilename = strdup(name);
  devices[anz_geraete].devicedescription = strdup(type);
  devices[anz_geraete].model = strdup(model);
  devices[anz_geraete].laeuft = 0;
  devices[anz_geraete].selected = 0;
  devices[anz_geraete].durchsatz = 0;
  devices[anz_geraete].last_value = 0;
  devices[anz_geraete].groesse = groesse;
  devices[anz_geraete].groessegeaendert = 0;
  devices[anz_geraete].ende = (34 == 56);
  devices[anz_geraete].getblock2k = getblock2k;
  anz_geraete++;
}

int getblock2k_cdrom(int fd)
{
  long anzbl = 0;
  char n[1<<11];
  int diff = 1 << 19;

  if(read(fd,n,1<11) <= 0) return 0;
  for(; diff > 0; diff >>= 1)
  {
    lseek(fd, (anzbl + diff - 1) << 11, SEEK_SET);
    if(read(fd,n,1<11) > 0) anzbl += diff;
  }
  lseek(fd, 0, SEEK_SET);
  return anzbl;
}

int getblock2k_hd(int fd)
{
  long anzbl = 0;
  ioctl(fd, BLKGETSIZE, &anzbl);
  if(anzbl == -1) return getblock2k_cdrom(fd);
  return anzbl >> 2;
}

int getblock2k_fd(int fd)
{
  long anzbl = 0;
  char n[100];

  if(ioctl(fd, FDGETDRVTYP, n) == -1) return 0;
  anzbl = atoi(n+1) << 1;
  return anzbl >> 2;
}

int getblock2k_special(int)
{
  return 42;
}

int getblock2k_bestguess(int fd)
{
  int b2k;

  if((b2k = getblock2k_hd(fd)) > 0) return b2k;
  return 42;
}

long gethdblocks(char *name)
{
  int fd;
  long anzbl = 0;

  fd = open(name, O_RDONLY);
  if(fd == -1) return 0;
  if(ioctl(fd, BLKGETSIZE, &anzbl) == -1) anzbl = 0;
  close(fd);
  return anzbl;
}

void insertdevice(char *name)
{
  struct stat buf;
  char *type;

  /* Mal sehen, ob wir irgendwas ueber das Geraet herausfinden ... */
  if(stat(name, &buf) == -1)
  {
    insertgeraet(name, "???", "???", getblock2k_bestguess, 0);
    return;
  }
  if(S_ISCHR(buf.st_mode)) /* Char-Device */
  {
    buf.st_rdev &= 0xffff;
    type = (char*)malloc(100);
    switch(MAJOR(buf.st_rdev))
    {
      default:
        sprintf(type, "CharDev (%d,%d)", MAJOR(buf.st_rdev), MINOR(buf.st_rdev));
        insertgeraet(name, type, name, getblock2k_bestguess, 0);
    }
    free(type);
    return;
  }
  if(S_ISBLK(buf.st_mode)) /* Block-Device */
  {
    int fd;
    struct hd_driveid hddi;
  
    type = (char*)malloc(100);
    switch(MAJOR(buf.st_rdev))
    {
      case 1:
        sprintf(type, "%s RAM disc", numbers[MINOR(buf.st_rdev)]);
        insertgeraet(name, type, "", getblock2k_hd, gethdblocks(name) << 9);
        break;
      case 2:
        sprintf(type, "%s Floppy Drive", numbers[buf.st_rdev & 3]);
        insertgeraet(name, type, "", getblock2k_fd, 0);
        break;
      case 3:
        if(MINOR(buf.st_rdev) & 63)
          sprintf(type, "1st IDE %s Part %d",
                  (MINOR(buf.st_rdev)&64?"Slave":"Master"), MINOR(buf.st_rdev) & 63);
        else
          sprintf(type, "1st IDE %s", (MINOR(buf.st_rdev)&64?"Slave":"Master"));


        fd = open(name, O_RDONLY);
        if(fd != -1)
        {
          if(ioctl(fd, HDIO_GET_IDENTITY, &hddi) == -1) hddi.model[0]=0;
          close(fd);
        }
        insertgeraet(name, type, (char*)hddi.model, getblock2k_hd, 
                     gethdblocks(name) << 9);
        break;
      case 7:
        sprintf(type, "%s Loopback Device", numbers[MINOR(buf.st_rdev)]);
        insertgeraet(name, type, "", getblock2k_hd, gethdblocks(name) << 9);
        break;
      case 8:
        if(MINOR(buf.st_rdev) & 0xf)
          sprintf(type, "%s SCSI Drive Part %d",
                  numnumbers[MINOR(buf.st_rdev)>>4], MINOR(buf.st_rdev) & 0xf);
        else
          sprintf(type, "%s SCSI Drive", numnumbers[MINOR(buf.st_rdev)>>4]);
        insertgeraet(name, type, (char*)hddi.model, getblock2k_hd, 
                     gethdblocks(name) << 9);
        break;
      case 9:
        sprintf(type, "%s Metadisc Device", numbers[MINOR(buf.st_rdev)]);
        insertgeraet(name, type, "", getblock2k_hd, gethdblocks(name) << 9);
        break;
      case 11:
        sprintf(type, "%s SCSI CD-ROM", numnumbers[MINOR(buf.st_rdev)]);
        insertgeraet(name, type, "", getblock2k_cdrom, 0);
        break;
      case 15:
      case 16:
      case 17:
      case 18:
      case 20:
      case 23:
      case 24:
      case 25:
      case 26:
      case 27:
      case 28:
      case 29:
      case 30:
      case 32:
        insertgeraet(name, "Proprietary CD-ROM", proprienames[MAJOR(buf.st_rdev)],
                     getblock2k_cdrom, 0);
        break;
      case 22:
        if(MINOR(buf.st_rdev) & 63)
          sprintf(type, "2nd IDE %s Part %d",
                  (MINOR(buf.st_rdev)&64?"Slave":"Master"), MINOR(buf.st_rdev) & 63);
        else
          sprintf(type, "2nd IDE %s", (MINOR(buf.st_rdev)&64?"Slave":"Master"));


        fd = open(name, O_RDONLY);
        if(fd != -1)
        {
          if(ioctl(fd, HDIO_GET_IDENTITY, &hddi) == -1) hddi.model[0]=0;
          close(fd);
        }
        insertgeraet(name, type, (char*)hddi.model, getblock2k_hd, 
                     gethdblocks(name) << 9);
        break;
      case 33:
        if(MINOR(buf.st_rdev) & 63)
          sprintf(type, "3rd IDE %s Part %d",
                  (MINOR(buf.st_rdev)&64?"Slave":"Master"), MINOR(buf.st_rdev) & 63);
        else
          sprintf(type, "3rd IDE %s", (MINOR(buf.st_rdev)&64?"Slave":"Master"));


        fd = open(name, O_RDONLY);
        if(fd != -1)
        {
          if(ioctl(fd, HDIO_GET_IDENTITY, &hddi) == -1) hddi.model[0]=0;
          close(fd);
        }
        insertgeraet(name, type, (char*)hddi.model, getblock2k_hd, 
                     gethdblocks(name) << 9);
        break;
      case 34:
        if(MINOR(buf.st_rdev) & 63)
          sprintf(type, "4th IDE %s Part %d",
                  (MINOR(buf.st_rdev)&64?"Slave":"Master"), MINOR(buf.st_rdev) & 63);
        else
          sprintf(type, "4th IDE %s", (MINOR(buf.st_rdev)&64?"Slave":"Master"));


        fd = open(name, O_RDONLY);
        if(fd != -1)
        {
          if(ioctl(fd, HDIO_GET_IDENTITY, &hddi) == -1) hddi.model[0]=0;
          close(fd);
        }
        insertgeraet(name, type, (char*)hddi.model, getblock2k_hd, 
                     gethdblocks(name) << 9);
        break;
      default:
        sprintf(type, "BlockDev (%d,%d)", MAJOR(buf.st_rdev), MINOR(buf.st_rdev));
        insertgeraet(name, type, name, getblock2k_bestguess, 0);
    }
    free(type);
    return;
  }
  /* Dann also auf eigene Gefahr... */
  insertgeraet(name, "???", name, getblock2k_bestguess, 0);
}

void lies_proc_scsi()
{
#define MAXPROCSIZE 4096
  FILE *proc_scsi;
  int size;
  char *buff, *b;
  char *type, *model;
  int fd;
  char sdn[] = "/dev/sda";
  char srn[] = "/dev/sr0";

  /* Erst mal testen, um scsi zu initialisieren */
  fd = open("/dev/sda", O_RDONLY);
  if(fd != -1) close(fd);
  proc_scsi = fopen("/proc/scsi/scsi", "r");
  if(proc_scsi == NULL) return;
  b = buff = (char *)malloc(MAXPROCSIZE + 1);
  size = fread(buff, 1, MAXPROCSIZE, proc_scsi);
  type = (char *) malloc(100);
  model = (char *) malloc(26);
  buff[size] = 0;
  while(*b != 0)
  {
    if(strncmp(b, "Attached devices:", 17) == 0)
    {
      while((*b != 0) && (*b != '\n')) b++;
      if(*b == '\n') b++;
      continue;
    }
    if(strncmp(b, "Host:", 5) == 0)
    {
      sprintf(type, "SCSI-Adapter %c Id %c%c", b[10], b[28], b[29]);
      while((*b != 0) && (*b != '\n')) b++;
      if(*b == '\n') b++;
      strncpy(model, b + 10, 9);
      strncpy(model + 9, b + 26, 16);
      model[9+16] = 0;
      while((*b != 0) && (*b != '\n')) b++;
      if(*b == '\n') b++;
      while(*b == ' ') b++;
      if((strncmp(b, "Type:   Direct-Access", 21) == 0) ||
         (strncmp(b, "Type:   Optical Device", 22) == 0))
      {
        long long si = gethdblocks(sdn);
        /* Platte gefunden!!! */
        insertgeraet(sdn, type, model, getblock2k_hd, si << 9);
        sdn[7] ++;
        goto erkannt;
      }
      if((strncmp(b, "Type:   CD-ROM", 14) == 0) ||
         (strncmp(b, "Type:   WORM", 12) == 0))
      {
        /* CD-ROM gefunden!!! */
        insertgeraet(srn, type, model, getblock2k_cdrom, 0);
        srn[7] ++;
        goto erkannt;
      }
      if((strncmp(b, "Type:   Sequential-Access", 25) == 0) ||
         (strncmp(b, "Type:   Printer", 15) == 0) ||
         (strncmp(b, "Type:   Processor", 17) == 0) ||
         (strncmp(b, "Type:   Scanner", 15) == 0) ||
         (strncmp(b, "Type:   Medium Changer", 22) == 0) ||
         (strncmp(b, "Type:   Communications", 22) == 0))
      {
        /* Nichts ordentliches gefunden!!! */
        goto erkannt;
      }
      strncpy(type, b + 5, 20);
      type[20] = 0;
      printf("Unbekannter Typ %s.\n", type);
      erkannt:
      while((*b != 0) && (*b != '\n')) b++;
      if(*b == '\n') b++;
      continue;
    }
    
  }
  free(model);
  free(type);
  free(buff);
  fclose(proc_scsi);
}

int lies_proc_ide()
{
  FILE * f;
  int fd;
  char name[] = "/dev/hdx";
  char namemedia[] = "/proc/ide/hdx/media";
  char namemodel[] = "/proc/ide/hdx/model";
  char c;
  int type_id = 0;
  char *type, *model;

#define HD_TYP_ID 1
#define CDROM_TYP_ID 2

  /* Erst mal testen, um IDE zu initialisieren */
  fd = open("/dev/hda", O_RDONLY);
  if(fd != -1) close(fd);
  f = fopen("/proc/ide", "r");
  if(f == NULL)
  {
    return (0==1);
  }
  fclose(f);
  type = (char *)malloc(101);
  model = (char *)malloc(101);
  
  for(c = 'a'; c <= 'd'; c++)
  {
    name[7] = c;
    namemedia[12] = c;
    namemodel[12] = c;
    f = fopen(namemedia, "r");
    if(f == NULL) continue;
    fgets(type, 99, f);
    fclose(f);
    if(strncmp(type, "disk", 4) == 0) type_id = HD_TYP_ID;
    if(strncmp(type, "cdrom", 5) == 0) type_id = CDROM_TYP_ID;
    if(strncmp(type, "tape", 5) == 0) continue;
    if(strncmp(type, "floppy", 5) == 0) continue /* Oder was?*/;
    if(strncmp(type, "UNKNOWN", 5) == 0) continue;
    if(type_id == 0) 
    {
      printf("Unbekannter IDE-Geraete-Type \"%s\".\n", type);
      continue;
    }
    
    f = fopen(namemodel, "r");
    if(f == NULL) model[0] = 0;
    else
    {
      fgets(model, 99, f);
      if(model[strlen(model)-1] == '\n') model[strlen(model)-1] = 0;
      fclose(f);
    }
    sprintf(type, "%s IDE %s", ((c-1)&2 ? "2nd" : "1st"), (c&1 ? "Master" : "Slave"));
    if(type_id == HD_TYP_ID) 
      insertgeraet(name, type, model, getblock2k_hd, (long long)gethdblocks(name) << 9);
    if(type_id == CDROM_TYP_ID)
      insertgeraet(name, type, model, getblock2k_cdrom, 0);
  }
  
  free(model);
  free(type);
  return (0==0);
}

void get_ide_devs()
{
  char hd_name[]="/dev/hdy";
  struct hd_driveid hddi;
  char c;
  char *type;

//  if(lies_proc_ide()) return; IDE-Proc geht doch noch nicht so...

  type = (char *)malloc(101);
  
  for(c = 'a'; c <= 'd'; c++)
  {
    int fd;

    hd_name[7] = c;
    fd = open(hd_name, O_RDONLY);
    if(fd == -1) continue;
 
    if(ioctl(fd, HDIO_GET_IDENTITY, &hddi) == -1) hddi.model[0]=0;

    sprintf(type, "%s IDE %s", ((c-1)&2 ? "2nd" : "1st"), (c&1 ? "Master" : "Slave"));

    if(strstr((char*)(&(hddi.model[0])), "CD-ROM") != NULL)
      insertgeraet(hd_name, type, (char *)hddi.model, getblock2k_cdrom, 0);
    else
      insertgeraet(hd_name, type, (char *)hddi.model, getblock2k_hd,
                   (long long)getblock2k_hd(fd) << 11);
    close(fd);
  }
  free(type);
}

void *search_devices(void *)
{
  struct stat buf;
  
  /* Ganz zuerst die SCSI - Geraete */
  lies_proc_scsi();
  
  /* Dann die IDE-Platten */
  get_ide_devs();
  
  /* CD-ROM, falls proprietaer */
  if(stat("/dev/cdrom", &buf) != -1)
  {
    if((MAJOR(buf.st_rdev) < 50) && (proprienames[MAJOR(buf.st_rdev)] != NULL))
      insertgeraet("/dev/cdrom", "Proprietary CD-ROM" , 
                   proprienames[MAJOR(buf.st_rdev)], getblock2k_cdrom, 0);
  }
  
  /* Dann die Floppies */
//   insertgeraet("/dev/fd0", "First Floppy Drive" , "?", getblock2k_fd, 0);
//   insertgeraet("/dev/fd1", "Second Floppy Drive" , "?", getblock2k_fd, 0);
  
  searchfinished = (42==42);
  return NULL;
}

int bench_init()
{
  static int inited = (1243 != 1243);

  if(inited) return (0==1);
  pthread_create(&searcher, NULL, search_devices, NULL);
//  search_devices(NULL);
  inited = (42 == 42);
  return 0==0;
}

inline long zeitdiff(struct timeval t1, struct timeval t0)
{
  return (t1.tv_sec - t0.tv_sec) * 1000000 + 
    (signed long)t1.tv_usec - (signed long)t0.tv_usec;
}

void *read_device(Device *g)
{
  int fd;
  char *buff = NULL;
  int buffsize = 0;
  int block2k = 0;
  struct timezone tz = {0,0};
  struct timeval tv0, tv1;
  long t;
  int counter;

  fd = open(g->devicefilename, O_RDONLY);
  if(fd == -1)
  {
//    printf("Konnte %s nicht oeffnen!\n", g->name);
    if(g->groesse)
    {
      g->groesse = 0;
      g->groessegeaendert = 1;
    }
    goto read_device_ende;
  }
  block2k = g->getblock2k(fd);
  if(block2k == 0)
  {
//    printf("Please insert disc in %s!\n", g->name);
    if(g->groesse)
    {
      g->groesse = 0;
      g->groessegeaendert = 1;
    }
    goto read_device_fast_ende;
  }
  if((g->groessegeaendert = (((long long)block2k << 11) != g->groesse)))
    g->groesse = (long long)block2k << 11;
  g->durchsatz = 0;
  while(!g->ende)
  {
    counter = 0;
    gettimeofday(&tv0, &tz);
    do
    {
      if(blocksize != buffsize)
      {
        buffsize = blocksize;
        buff = (char *)realloc(buff, buffsize);
      }
      if(random_read)
        lseek(fd, (long int)(block2k * drand48()) << 11, SEEK_SET);
      if(read(fd, buff, buffsize)>0)
        counter += (buffsize >> 10);
      else
        lseek(fd, 0, SEEK_SET);
      gettimeofday(&tv1, &tz);
    }
    while((t = zeitdiff(tv1, tv0)) < ZEITGRENZE);
    g->durchsatz = (int)(1000000 * (float)counter / t);
//     if(g->getblock2k == getblock2k_cdrom)
//       printf("%.2fx\n", (float)(g->durchsatz)/150);
  }
  g->durchsatz = 0;
  free(buff);
  read_device_fast_ende:
  close(fd);
  read_device_ende:
  g->laeuft = 0;
  return NULL;
}

void starte_geraete()
{
  int i;
  Device *g;

  for(i = 0, g = devices; i < anz_geraete; i++, g++)
    if(g->selected != g->laeuft)
      if(g->selected)
      {
        g->laeuft = (0==0);
        g->ende = (0==1);
        pthread_create(&(g->reader), NULL, read_device, (devices + i));
      }
      else
      {
        g->ende = (0==0);
      }
}

void stoppe_geraete()
{
  int i;
  Device *g;

  for(i = 0, g = devices; i < anz_geraete; i++, g++)
    g->ende = (0==0);
}
