/*  Copyright (c) 1993 by Tycho Softworks.  All rights reserved.

	Master include file for VU system.
*/

#ifndef __VU_H__
#define __VU_H__

#ifndef	__PROTOTYPES_H__
#define	__PROTOTYPES_H__

#ifdef	QNX
#ifdef	C86
#define	__ANSI__
#endif
#endif

#ifndef	__ANSI__
#ifdef	__STDC__
#if		__STDC__ != 0
#define	__ANSI__
#endif
#endif
#endif

#ifdef	PROTO
#undef	PROTO
#endif

#ifdef	IMPORT
#undef	IMPORT
#endif

#ifdef	FORWARD
#undef	FORWARD
#endif

#ifdef	__ANSI__
#define	PROTO(s)	s
#define	IMPORT
#define	FORWARD		static
typedef	void *		PTR;
#else
#define	PROTO(s)	()
#define	IMPORT		extern
#define	FORWARD		static
typedef	char *		PTR;
#endif

#ifndef	PASCAL
#define	PASCAL
#endif

#endif

#ifdef	__ANSI__
#include <stddef.h>
#include <malloc.h>
#define	VUARGS	struct vuport *, EVENT event, PARM p1, PARM p2
#define	VUNULL	((int (*)(VUARGS))0l)
#define	CARGS 	struct vuport *, struct cport *control, EVENT event, PARM p1, PARM p2 
#define	CNULL	((int (*)(CARGS))0l)
#define	TARGS	int timer
#define	TNULL	((int (*)(TARGS))0l)
#define	__vutoc(proc)	((int (*)(CARGS))proc)
#else
#define	VUNULL	NULL
#define	CNULL	NULL
#define	TNULL	NULL
#define	VUARGS	
#define	CARGS
#define	TARGS
#define	__vutoc(proc)	proc
#endif

#include <time.h>
#include <stdio.h>
#ifdef	__ANSI__
#include <string.h>
#endif
#include <stdlib.h>

#ifdef	SCO
#define	__ADDSTR__
#endif

#ifdef	LINUX
#define	__ADDSTR__
#endif

#ifndef  __ANSI__      /* need old string prototypes */

/*
	Common string functions for VU applications.  This module also
	provides support for string functions which may be missing in
	some system libraries.
*/

extern char *strcpy(), *strncpy(), *strcat(), *strncat(), *strchr(), *strrchr(),
			*strpbrk(), *strstr(), *strerror(), *strtok();

extern int  strcmp(), stricmp(), strncmp(), strnicmp(), strspn(), strcspn(), 
			strlen(), memcmp();

#undef  __STRING__
#endif


#ifdef	__ANSI__
#ifdef	__ADDSTR__
IMPORT	int	stricmp PROTO((char *s1, char *s2));
IMPORT	int	strnicmp PROTO((char *s1, char *s2, int n));
IMPORT	char	*strlwr PROTO((char *s));
IMPORT	char	*strupr PROTO((char *s));
#endif
#endif

/*  bool flags */

#define FALSE   0
#define TRUE    1

/*  To compose line drawing graphics */

#define BOX_U           0x0001
#define BOX_D           0x0002
#define BOX_L           0x0004
#define BOX_R           0x0008

#define ARROW_U         0x0088
#define ARROW_D         0x0089
#define	ARROW_L			0x0090
#define	ARROW_R			0x0091

#define	CARD_CLUBS		0x0092
#define	CARD_DIAMONDS	0x0093
#define	CARD_HEARTS		0x0094
#define	CARD_SPADES		0x0095

/*  button shadows */

#define BOX_FILL_TOP    0x0080
#define BOX_FILL_BOT    0x0081
#define BOX_SOLID       0x0083
#define BOX_SHADED      0x0084

/*      key code values */

#define ALTKEY          0x0100          /* alt key press, can be masked out */

/*      cell flags      */

#define TRANSPARENT     0x7fff          /* transparent cell code */
#define REFRESH_CELL    0x8000
#define GRAPHIC_CELL    0x4000          /* ctrl characters remap */
#define PALMASK_CELL    0x3f00
#define CHRMASK_CELL    0x00ff

/*      window attributes */

#define HASSHADOW       0x0001          /* shadowing */
#define HASBORDER       0x0002          /* has border */
#define HASTITLE        0x0004          /* has title  */
#define HASIMAGE        0x0008          /* can save image */
#define LOCKED          0x0010          /* locked object */
#define HASMENUBAR      0x0020          /* has a menu bar */
#define DESKTOP         0x0040          /* paired with desktop/application */
#define BLOCKED         0x0080          /* I/O inactive/busy */
#define FAILURE         0x0100          /* failure window - terminate */
#define ACTIVE          0x0200          /* active in background */
#define MOVEFRONT       0x0400
#define REMOVED         0x1000
#define EDITBAR         0x2000
#define WORDWRAP        0x4000
#define VISIBLE         0x8000          /* changed on front-to-back */

/*  pallette attributes */

/*  background colors */

#define BLACK           0x00
#define BLUE            0x10
#define GREEN           0x20
#define CYAN            0x30
#define RED             0x40
#define MAGENTA         0x50
#define YELLOW          0x60
#define BROWN           0x60
#define ORANGE          0x60
#define WHITE           0x70

/*      foreground colors */

#define DARKBLACK       0x0
#define DARKBLUE        0x1
#define DARKGREEN       0x2
#define DARKCYAN        0x3
#define DARKRED         0x4
#define DARKMAGENTA     0x5
#define DARKBROWN       0x6
#define DARKWHITE       0x7

#define LIGHTGREY       0x8
#define LIGHTBLUE       0x9
#define LIGHTGREEN      0xa
#define LIGHTCYAN       0xb
#define LIGHTRED        0xc
#define LIGHTMAGENTA    0xd
#define LIGHTYELLOW     0xe
#define LIGHTWHITE      0xf

#define STAT_INFO       DARKWHITE | BLACK
#define STAT_BUSY       DARKBLUE  | BLACK
#define STAT_WARNING    DARKBROWN | BLACK
#define STAT_ERROR      DARKRED   | BLACK
#define STAT_GOOD       DARKGREEN | BLACK

/*      monochrome attributes */

#define INVERSE         0x0080
#define UNDERLINE       0x0100
#define BRIGHT          0x0200  
#define BLINK           0x0400
#define SUBUNDERLINE    0x0800          /* hint mask */
#define SUBBRIGHT       0x1000          /* hint mask */
#define SUBINVERSE      0x2000          /* hint mask */
#define SPECIAL         0x4000          /* graphic cell */

#define COLORATTRMASK   (0x7f | BLINK | SPECIAL)
#define MONOATTRMASK    (0xff80)


/*  timers */

#define MAX_TIMERS  8

/*  some common data types */
                     
#ifndef	__BOOL_H__
#define	__BOOL_H__
#define BOOL_H
typedef	unsigned char	bool;			/* little bool */
typedef int             BOOL;           /* bool flags */
#endif

typedef short           PARM;           /* window message param */
typedef unsigned short  ATTR;           /* attributes flag */
typedef unsigned short  CELL;           /* cell of imaginary screen */
typedef char        *STRING;            /* string type */
typedef unsigned char   PAL;            /* pallette table pointer */

typedef enum                            /* build event definitions */
{
	VU_IDLE=512,                        /* null event */
	VU_CREATE,                          /* vu object create message */
	VU_DESTROY,                         /* vu object destroy message */
	VU_PAINT,                           /* vu object paint message */
	VU_PAINT_SELECT,                    /* used for select lists */
	VU_REDRAW,                          /* vu object cell repaint */
	VU_REFRESH,                         /* refesh screen */
	VU_FRONT,                           /* vu object now in front */
	VU_BACK,                            /* vu object now in back */
	VU_KEYBOARD,                        /* vu obect keyboard event */
	VU_NOTIFY,                          /* notify for window termination */
	VU_BUTTON,                          /* button event */

/* control markers */   

	VU_ACCEPT,                          /* accept button press */
	VU_CANCEL,                          /* cancel button press */
	VU_SHUTDOWN,                        /* shutdown message to desktop */
	VU_SHELL,                           /* shell message to desktop (not used) */

/* warning message box events */

	VU_FAIL,
	VU_RETRY,

	VU_SELECT,                          /* select item control marker */
	VU_TAG,                             /* select tag button */

	VU_ENTER,                           /* field validation */
	VU_EXIT,

	VU_USERID,
	VU_USERNAME,
	VU_USERNAMEID,

	VU_BLANK,                           /* blank the screen */
	VU_SIGNAL,                          /* signal exception */

	/* p1 and p2 hold row and col mouse position */

	VU_MOUSE_LEFT_PRESS,                /* mouse pressed event */
	VU_MOUSE_LEFT_RELEASE,              /* released without move */
	VU_MOUSE_LEFT_DRAG,                 /* dragged while pressed */
	VU_MOUSE_LEFT_DROP,                 /* dropped after move */

	VU_MOUSE_RIGHT_PRESS,
	VU_MOUSE_RIGHT_RELEASE,
	VU_MOUSE_RIGHT_DRAG,
	VU_MOUSE_RIGHT_DROP,

	VU_FILE_NAME,
	VU_FILE_PATH,
	VU_OPEN,
	VU_CLOSE,
	VU_VOLUME,
	VU_PARENT,
	VU_SAVE,
	VU_SCAN_DIR,

	VU_HELP,
	VU_FRAME,
	VU_MENU,
	VU_BAR,
	VU_FORMAT,
	VU_APB,

	VU_USER=1024                        /* user events added here */
}   EVENT;

typedef struct
{
	short   tp;
	short   bt;
	short   lt;
	short   rt;
}   RECT;

#ifdef	__STDC__
struct	vuport;				/* fix for circular def in CARGS */
#endif

typedef struct	cport                      /* control items */
{
	BOOL        PASCAL  (*cproc)(CARGS);
	STRING      ctext;
	short       crow,ccol,clen,cwid;
	short       ctag;
	short       cstate;
	STRING      cmsg;
}   CITEM;

typedef struct  vuport
{
	RECT    vudrawn;                    /* where is it drawn */ 
	RECT    vuorigin;                   /* original creation */

	struct  vuport  *vunext;            /* next window on screen */
	struct  vuport  *vuprev;            /* previous window on screen */
	struct  vuport  *vuparent;          /* used to pass messages back */

	ATTR    vuattr;                     /* window attributes */
	PAL     vupal;                      /* screen pallette set used */
	STRING  vutitle;                    /* title of window */
	PTR		vuimage;                   /* saved image (not used currently) */
	STRING  vustatline;                 /* status line message */
	short   vustatcolor;

	short   vucurrow;                   /* cursor row, col, and mode when in front */
	short   vucurcol;
	short   vucurmode;
	short   vuscroll;                   /* scroll partition hot point */

	BOOL    PASCAL  (*vuproc)(VUARGS);  /* handler routine */
	PTR     vupaint;                    /* interior painting structure */

	short   vunotify;                   /* notify state flag */
	short   vuresid;                    /* resource id for window resource */

	int     vuoptions[8];               /* 16 bytes reserved */

	CITEM   *vucontrol;                 /* current control item */

	CITEM   vucontrols[1];              /* attached controls */

}       *VUPORT;

typedef VUPORT  VU;                     /* alias of VUPORT handle type */

typedef struct
{
	ATTR    palattr;                    /* attribute map */
	PAL     palshadow;                  /* shadow entry */
}   PALDEF;

typedef struct
{
	int     sel_list;                   /* size of news list */ 
	int     sel_base;                   /* offs[Iet to top of list */
	int     sel_mark;                   /* mark position in table */
	int     sel_size;                   /* size of select table (num records) */
	CITEM   *sel_box;                   /* associated box control */
	CITEM   *sel_txt;                   /* associated edit control */
	
}   *SELECT;

typedef	struct
{
	BOOL	desk_shutdown;
	BOOL	desk_locked;
	time_t	desk_mail;
	time_t	desk_apb;
	VU		desk_notice;
	char	*desk_ntext;
}	*DESKOPTS;

/*  external variables */

extern  VUPORT      front;              /* current window at top of display */
extern  VUPORT      back;               /* current window at end of display */
extern  VUPORT      desktop;            /* application desktop */
extern  PALDEF      palette[];          /* master pallette table */
extern  RECT        viewport;           /* portion of screen modifiable */
extern  CELL        *imageport;         /* imaginary screen memory */
extern  CELL        deskpattern;        /* desktop pattern */
extern  int         rows,cols;          /* true screen size */
extern  BOOL        color;              /* true if color active */
extern  int         imageline[];        /* image line mark table */
extern  unsigned    speed;              /* effective baud rate */
extern  int         alert_mode;         /* beep level */
extern  BOOL        insert_mode;        /* insert toggle key */
extern  int         shutdown_flag;
extern  BOOL        keyboard_timer;     /* clear for real-time response */
extern  int         shutdown_mode;
extern  int         redraw;
extern  int         force_update;       /* force update flag */
extern  int         vuoptind,vuoptopt;
extern  BOOL        inverse_mode;
extern  BOOL        console_mode;       /* 1 for local video */
extern  char        *vuoptarg;
extern	char		*deffkeys[];

/*  macros  */

#define VUGetAttr(vu,attr)              (vu->vuattr & attr)
#define VUSetAttr(vu,attr)              (vu->vuattr |= attr)
#define VUClrAttr(vu,attr)              (vu->vuattr &= ~attr)

/*  resource models */

#define WINDOW(tag)                     extern  CITEM   tag[]

#define VUEvent(vu,event,p1,p2)         ((*(vu->vuproc))(vu,event,p1,p2))
#define VUControl(vu,control,event,p1,p2)   ((*(control->cproc))(vu,control,event,p1,p2))

#define DEFWINDOW(tag)                  CITEM    tag[] = {{
#define DEFMENU(tag)                    CITEM    tag[] = {{
#define WIN_CLASS(proc,ttl)             __vutoc(proc),ttl,
#define WIN_ATTR(l,w,a,p,msg)           a,p,l,w,0,0,msg},
#define RES_ATTR(l,w,a,p,res,msg)       a,p,l,w,res,0,msg},
#define	BAR_CONTROL(r, c, w,tag)		{VUBarControl, "",r,c,3,w+2,tag,0,NULL},
#define LINE_CONTROL(str,r,c)           {VULineControl,str,r,c,0,0,0,0,NULL},
#define	FILL_CONTROL(r,c,l,w,p)			{VUFillControl,NULL,r,c,l,w,0,p,NULL},
#define TEXT_CONTROL(str,r,c,l,w,tag)   {VUTextControl,str,r,c,l,w,tag,1,NULL},
#define TEXT_FIELD(str,r,c,l,w,clr)     {VUTextControl,str,r,c,l,w,0,clr,NULL},
#define EDIT_CONTROL(buf,r,c,l,w,tag,a) {VUEditControl,buf,r,c,l,w,tag,0,a},
#define CUSTOM(cmd,buf,r,c,l,w,tag,a)   {cmd,buf,r,c,l,w,tag,0,a},
#define BOX_CONTROL(str,r,c,l,w,tag)    {VUBoxControl,str,r,c,l,w,tag,0,NULL},
#define EDITLN_CONTROL(buf,r,c,w,tag,a) {VUEditLnControl,buf,r,c,1,w,tag,0,a},
#define EDITID_CONTROL(buf,r,c,w,tag,a) {VUEditIdControl,buf,r,c,1,w,tag,0,a},
#define EDITFN_CONTROL(buf,r,c,w,tag,a) {VUEditFnControl,buf,r,c,1,w,tag,0,a},
#define EDITPW_CONTROL(buf,r,c,w,tag,a) {VUEditPwControl,buf,r,c,1,w,tag,0,a},
#define EDITNUM_CONTROL(buf,r,c,w,tag,a) {VUEditNumControl,buf,r,c,1,w,tag,0,a},
#define EDITTIME_CONTROL(buf,r,c,tag,a) {VUEditTimeControl,buf,r,c,1,5,tag,0,a},
#define SELECT_CONTROL(buf,r,c,w,tag,l) {VUSelectControl,(char *)buf,r,c,1,w,tag,0,(char *)l},
#define MENU_CONTROL(buf,r,c,l,w,tag,m) {VUMenuListControl,buf,r,c,l,w,tag,0,(char *)m}, 
#define LIST_CONTROL(buf,r,c,l,w,tag,t) {VUSelectListControl,(char *)buf,r,c,l,w,tag,0,(char *)t},
#define CHECK_CONTROL(buf,r,c,tag)      {VUCheckboxControl,(char *)buf,r,c,1,3,tag,0,NULL},
#define EDITDATE_CONTROL(buf,r,c,tag,a) {VUEditDateControl,buf,r,c,1,8,tag,0,a},
#define BUTTON_CONTROL(s,r,c,w,tag)     {VUButtonControl,s,r,c,1,w,tag,0,NULL},
#define MENU_ITEM(n,r,c,w,tag,m,x)      {VUMenuControl,  n,r,c,1,w,tag,m,(char *)x},
#define EMPTY_CONTROL                   {CNULL,          0,0,0,0,0,0,0,0},
#define ENDDEF                          {CNULL,          0,0,0,0,0,0,0,0}};

#ifdef  __ANSI__
#define DEFPORT(tag)    BOOL    PASCAL tag(VU vu, EVENT event, PARM p1, PARM p2)
#define DEFCONTROL(tag) BOOL    PASCAL tag(VU vu, CITEM *control, EVENT event, PARM p1, PARM p2)
#define PORT(tag)       DEFPORT(tag)
#define CONTROL(tag)    DEFCONTROL(tag)
#define DEFTIMER(tag)   int PASCAL tag(int timer)
#define TIMER(tag)      DEFTIMER(tag)
#define PROGRAM         int main(int argc, char **argv)
#else
#define DEFPORT(tag)    BOOL    PASCAL tag(vu,event,p1,p2) VU vu; EVENT event; PARM p1,p2;
#define DEFCONTROL(tag) BOOL    PASCAL tag(vu,control,event,p1,p2) VU vu; CITEM *control; EVENT event; PARM p1,p2;
#define PORT(tag)       BOOL    PASCAL tag()
#define CONTROL(tag)    BOOL    PASCAL tag()

#define DEFTIMER(tag)   int PASCAL tag(timer) int timer;
#define TIMER(tag)      extern int PASCAL tag()
#define PROGRAM         int main(argc,argv) int argc; char **argv;
#endif

#define USEPORT(tag)    tag(vu,event,p1,p2)
#define USECONTROL(tag) tag(vu,control,event,p1,p2)

#define true    return TRUE
#define false   return FALSE

/*  standard vu library resources:

	The standard VU templates are broken down by national replacement
	object sets when appropriate.  Objects which are not nation specifc
	are listed only once.
*/

/*  non-nation specific templates */

WINDOW(UserDesktop);
WINDOW(VUDesktop);      /* standard vu application desktop */
WINDOW(YesNoBox);       /* yes-no box template */
WINDOW(VUHelp);         /* standard help window template */
WINDOW(VUStdFile);

/*  external procedures */

CONTROL(VUBoxControl);
CONTROL(VUButtonControl);
CONTROL(VUEditTimeControl);
CONTROL(VUEditControl);
CONTROL(VUEditLnControl);
CONTROL(VUEditPwControl);
CONTROL(VUEditIdControl);
CONTROL(VUEditFnControl);
CONTROL(VUEditNumControl);
CONTROL(VUTextControl);
CONTROL(VUEditDateControl);
CONTROL(VUEditTimeControl);
CONTROL(VUCheckboxControl);
CONTROL(VUYesNoControl);
CONTROL(VUMenuControl);
CONTROL(VUSelectControl);
CONTROL(VUSelectListControl);
CONTROL(VUMenuListControl);
CONTROL(VULineControl);
CONTROL(VUFillControl);
CONTROL(VUBarControl);

PORT(VUWindowPort);
PORT(VUFormPort);
PORT(VUFlashPort);
PORT(VUDeskPort);
PORT(VUMenubarPort);
PORT(VUMenulistPort);
PORT(VUMsgboxPort);
PORT(VUSelectPort);
PORT(VUSelectListPort);
PORT(VUTagSelectPort);
PORT(VUCardPort);
PORT(VUNoticePort);
PORT(VUUserPort);
PORT(VUStdFilePort);
PORT(VUHelpTextPort);
PORT(VUHelpFilePort);
PORT(VUMenuPort);
PORT(VUMenuKeyPort);
PORT(VUMemoboxPort);
PORT(VUScrollPort);

IMPORT  void PASCAL VUSelectInsert PROTO((VU vu, int pos, char *item));
IMPORT  void PASCAL VUSelectAdd PROTO((VU vu, char *item));
IMPORT  void PASCAL VUSelectRemove PROTO((VU vu, int pos));
IMPORT  int  PASCAL VUSelectLocate PROTO((VU vu, char *item, int (*cmp)(char *s1, char *s2)));
IMPORT  int  PASCAL VUCallDA PROTO((char *progname));
IMPORT  void PASCAL VUDAStartup PROTO((int argc, char **argv));
IMPORT  void PASCAL VUDAShutdown PROTO((void));
IMPORT  int  PASCAL VUGetOpt PROTO((int argc, char **argv, char *opt, char *usage, char *help));
IMPORT  void PASCAL VUError PROTO((char *ttl, char *msg));
IMPORT  void PASCAL VUTermBlank PROTO((void));
IMPORT  void PASCAL VUChangeRect PROTO((VU vu, RECT *rc));
IMPORT  void PASCAL VUSetPalette PROTO((PAL id, ATTR value, PAL shadow));
IMPORT  void PASCAL VUAlarm PROTO((int id, int sec, int PASCAL (*proc)(TARGS)));
IMPORT  void PASCAL VUAbsAlarm PROTO((int id, time_t when, int PASCAL (*proc)(TARGS)));
IMPORT  void PASCAL VUTermAlert PROTO((int mode));
IMPORT  void PASCAL VUActiveControl PROTO((VU vu,int tag));
IMPORT  void PASCAL VUTouchControl PROTO((VU vu,int tag));
IMPORT  void PASCAL VUSetControl PROTO((VU vu, int tag, int state));
IMPORT  struct tm* PASCAL VUScanTime PROTO(( struct tm *mask , char *buf ));
IMPORT  void PASCAL VUPostRedraw PROTO(( EVENT mode , VU vu , RECT *rc ));
IMPORT  void PASCAL VUPostEvent PROTO(( VU vu , EVENT event , PARM p1 , PARM p2 ));
IMPORT  void PASCAL VUFlush PROTO(( void ));
IMPORT  void PASCAL VUUpdate PROTO(( void ));
IMPORT  int PASCAL VUDispatch PROTO(( void ));
IMPORT  BOOL PASCAL VUObscured PROTO((VU vu));
IMPORT  BOOL PASCAL VUCellObscured PROTO((VU vu, int row, int col));
IMPORT  BOOL PASCAL VUAllEvent PROTO(( EVENT event , PARM p1 , PARM p2 ));
IMPORT  BOOL PASCAL VUActiveEvent PROTO(( EVENT event , PARM p1 , PARM p2 ));
IMPORT  void PASCAL VUTextSize PROTO(( char *p1 , int *l , int *w ));
IMPORT  int PASCAL VUKeyMatch PROTO(( int k1 , int k2 ));
IMPORT  void PASCAL VUControlCursor PROTO(( VU v1 , CITEM *c1 , int row , int col ));
IMPORT  char * PASCAL VUCvtTime PROTO(( struct tm *now ));
IMPORT  char * PASCAL VUCvtDate PROTO(( struct tm *now ));
IMPORT  VU PASCAL VUFailMsg PROTO(( char *str , int row , int col ));
IMPORT  VU PASCAL VUErrorMsg PROTO(( char *str ));
IMPORT  void PASCAL VUImageFill PROTO(( RECT *r1 , CELL cell ));
IMPORT  void PASCAL VUDrawAbsCell PROTO(( CELL cell , int r , int c ));
IMPORT  void PASCAL VUDrawCell PROTO(( CELL cell , int r , int c ));
IMPORT  void PASCAL VUPressButton PROTO(( CITEM *c , VU v1 ));
IMPORT  void PASCAL VUDrawButtonUp PROTO(( STRING s1 , int row , int col , int wid , PAL shadow ));
IMPORT  void PASCAL VUDrawString PROTO(( STRING str1 , int r , int c , int max , CELL pal ));
IMPORT  void PASCAL VUDrawFrame PROTO(( VU v1 , CELL p1 ));
IMPORT  void PASCAL VUForceRedraw PROTO(( void ));
IMPORT  VU PASCAL VUYesNoBox PROTO(( VU parent , STRING str ));
IMPORT  void PASCAL sync_timer PROTO(( int tics ));
IMPORT  void PASCAL VUDestroy PROTO(( VU v1 ));
IMPORT  void PASCAL VUDestroyGroup PROTO(( VU vu ));
IMPORT  void PASCAL VUStartup PROTO(( void ));
IMPORT  void PASCAL VUShutdown PROTO(( void ));
IMPORT  VU PASCAL VUCreate PROTO(( CITEM *windef , STRING title , int row , int col , BOOL PASCAL (*proc)(VUARGS), ATTR attr , VU parent , void *paint ));
IMPORT  VU PASCAL VUCreateQ PROTO(( CITEM *windef , STRING title , int row , int col , void *paint ));
IMPORT  VU PASCAL VUCreateQR PROTO(( CITEM *windef , STRING title , int row , int col , char *text ));
IMPORT  void PASCAL VUToFront PROTO(( VU vu ));
IMPORT  void PASCAL VUToBack PROTO(( VU vu ));
IMPORT  void PASCAL VUDrawSeparator PROTO(( VU v1 , int line , PAL pal ));
IMPORT  void PASCAL cursor PROTO(( int r , int c ));
IMPORT  void PASCAL fixcursor PROTO(( void ));
IMPORT  RECT *PASCAL rcfix PROTO(( VU vu));
IMPORT  void PASCAL statln PROTO(( STRING msg ));
IMPORT  BOOL PASCAL VUPending PROTO(( void ));
IMPORT  int PASCAL VUTermUpdate PROTO(( void ));
IMPORT  int PASCAL VUTermPending PROTO(( void ));
IMPORT  int PASCAL VUTermKey PROTO(( void ));
IMPORT  int PASCAL VUTermStatLine PROTO(( STRING msg));
IMPORT  int PASCAL VUTermStartup PROTO(( void ));
IMPORT  void PASCAL VUTermShutdown PROTO(( void ));
IMPORT  void PASCAL VUFlashMessage PROTO((VU vu, char *msg));
IMPORT  void PASCAL VUDrawHLine PROTO((int row, int col, int len));
IMPORT  void PASCAL VUDrawVLine PROTO((int row, int col, int len));
IMPORT  void PASCAL VUDrawGrid PROTO((int row, int col, int len, int wid, int vsize, int hsize));
IMPORT  void PASCAL VUDrawBox PROTO((int row, int col, int len, int wid));
IMPORT  void PASCAL VUFillBox PROTO((int row, int col, int len, int wid, PAL pal));
IMPORT  void PASCAL VUTermBlank PROTO((void));
IMPORT  char *PASCAL VUTrimString PROTO((char *string, char *head, char *tail));
IMPORT  long PASCAL VUValString PROTO((char *string, short decimal));
IMPORT  char *PASCAL VUNumString PROTO((char *string, long value, short decimal));
IMPORT  BOOL PASCAL VUStrValid PROTO((char *string, char *valid));
IMPORT  char *PASCAL VUStrFilter PROTO((char *string, char *valid));
IMPORT  BOOL PASCAL VUStrEmpty PROTO((char *string));
IMPORT  int PASCAL  VUBuildMemoList PROTO((VU vu, char **ptrs, char *text, int max)); 
IMPORT	void PASCAL VUTermSuspend PROTO((BOOL cls));
IMPORT	void PASCAL VUTermContinue PROTO((void));
IMPORT	void PASCAL VUScrollText PROTO((VU vu, char *text));
IMPORT	void PASCAL VUScrollClear PROTO((VU vu));
#endif

