#ifndef	__DIR_H__
#define	__DIR_H__

#ifndef	__PROTOTYPES_H__
#include <prototypes.h>
#endif

#ifndef	__NAMES_H__
#include <sys_names.h>
#endif

#include <sys/stat.h>
#include <time.h>

typedef	struct	stat	DIRSTAT;

#ifdef	QNX
#include <stdio.h>
#define	DIRLIST	FILE
#define	__DIR__
#endif

#ifdef	LINUX
#define	__DIRENT__
#endif

#ifdef	COHERENT
#define	__DIRENT__
#endif

#ifdef	__DIRENT__
#include <dirent.h>
#endif

#ifndef	__DIR__

typedef	struct
{
	char	dir_path[PATH_NAME_LENGTH + 1];
	long	dir_dev;
#ifdef	__DIRENT__
	DIR		*dir_ctrl;	
#endif
}	DIRLIST;

#ifdef	__DIRENT__

typedef	struct	dirent	DIRENT;

#else

typedef	struct
{
	char	d_name[FILE_NAME_LENGTH + 1];
	long	d_ino;
}	DIRENT;
#endif
#endif

IMPORT	DIRLIST *open_dir PROTO((char *dirname));
IMPORT	void close_dir PROTO((DIRLIST *dir));
#ifdef	__DIRENT__
#define	read_dir(dir)	readdir(dir->dir_ctrl)
#else
IMPORT	DIRENT *read_dir PROTO((DIRLIST *dir));
#endif
IMPORT	DIRSTAT *stat_dir PROTO((DIRLIST *dir, DIRENT *entry));	/* void in qnx	*/

#endif
