/*	$Header$
	Copyright (c) 1993 by Tycho Softworks.  All rights reserved.

Created by:

	David Sugar, Tycho Softworks
   	E-Mail: dyfet@aol.com, BBS: 201-858-3429

Synopsis:

	Accesses system configuration database files.  These files are generally
	kept in a single global directory and have entries grouped by sections.
	Each section is marked with a special header ([header-name]).  Blank
	lines and comments are ignored.

History:

	$Log$
*/

#ifndef	__CONFIG_H__
#define	__CONFIG_H__

#include <stdio.h>

#ifndef	__PROTOTYPES_H__
#include <prototypes.h>
#endif

typedef	struct
{
	char	acs_flag;
	char	acs_id[31];
	char	acs_member[32];
	int		acs_uid;
}	ACS;

typedef	struct
{
	char	cfg_name[16];
	int		cfg_flag;
	FILE	*cfg_fp;
	char	cfg_lbuf[0];
}	CONFIG;

CONFIG *open_config PROTO((char *name));
CONFIG *user_config PROTO((CONFIG *cfg, char *name));
int	seek_config PROTO((CONFIG *cfg, char *name));
char *read_config PROTO((CONFIG *cfg));
void close_config PROTO((CONFIG *cfg));
char *get_config PROTO((CONFIG *cfg, char *option));
int	getacs PROTO((char *acs_id));
int	grpacs PROTO((char *acs_id));
#endif
