#include <termios.h>

#define TIMEOUT -42

struct vmodem {
  int type, fd;
  FILE *fp;
  char *device, initialized;
   
  virtual ~vmodem();
  virtual int read_char();
  virtual int raw(char *);
  virtual int init() = 0;
  virtual void restore() = 0;
  virtual void raw(char);
  virtual int wait4call();
  virtual void reset();
  virtual void flush();
  virtual int poll(int);
  virtual void sig(int);
  virtual void clean();
};

struct realmodem:public vmodem {
  void drain();
  void command(char *);
  char buf[256];
   
  struct termios oldstate, state;
   
  int wait4call();
  int connect();
  realmodem(char *);
  ~realmodem();
  int init();
  void restore();
  void reset();
};

struct localmodem:public vmodem {
  struct termios oldstate, state;
   
  ~localmodem();
  localmodem(char *);
  int init();
  void restore();
};
