#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <termios.h>
#include <unistd.h>
#include "os.h"
#include "output.h"
#include "status.h"
#include "tokens.h"
#include "varlist.h"

extern varlist list;
extern status_t *status_p;
extern int device_delay, ansi;
extern char initstring[], token[1024], *out_buf;
extern char no_key, cont_key;

int locked_txt[17] = {
  50, 75, 110, 134, 150, 200, 300, 600, 1200, 2400, 4800, 9600, 19200, 38400,
  57600, 115200, 230400    
};

int locked_int[17] = { 
  B50, B75, B110, B134, B150, B200, B300, B600, B1200, B2400, B4800, B9600,
  B19200, B38400, B57600, B115200, B230400 
};

void read_config()
{
  FILE *cfg;
  int type, line = 1;
  char var[21];
   
  cfg = fopen("/osbbs/data/config", "r");
   
  if(cfg == NULL) {
    perror("fopen");
    init_error("could not open /osbbs/data/config");
  }

  for(;;) {
    type = read_token(cfg);

    if(type == TOKEN_EOL || type == TOKEN_COMMENT) {
      line++;
      continue;
    }
     
    if(type == TOKEN_EOF)
      break;
     
    if(type != TOKEN_TEXT)
      init_error("error in config file line %d: variable expected", line);
 
    strncpy(var, token, 20);
     
    type = read_token(cfg);
     
    if(type == TOKEN_TEXT)
      list.add_sys(var, token);
    else if(type == TOKEN_NUM)
      list.add_sys(var, atoi(token));
    else
      init_error("error in config file line %d: value expected", line);
  }

  fclose(cfg);
}

void get_initstring()
{
  FILE *init;
  char *device;
  int type, t;

  device = list["device"] -> get_s();
   
  init = fopen("/osbbs/data/initstrings", "r");
  if(!init) {
    perror("fopen");
    init_error("error opening /osbbs/data/initstrings");
  }
   
  for(;;) { 
    type = read_token(init);
    if(type == TOKEN_COMMENT || type == TOKEN_EOL)
      continue;
    
    if(type == TOKEN_EOF)
      init_error("no initstring defined for device");
   
    if(type != TOKEN_TEXT) 
      init_error("error in initstrings file");
   
    if(!strcmp(device, token))
      break;
     
    skip_line(init);
  }
   
  read_token(init);
  device_delay = atoi(token);
  if(device_delay <= 0 || device_delay > 1000)
     init_error("weird delay value");

  read_token(init);
  for(t = 0;t < 17;t++)
    if(locked_txt[t] == atoi(token)) {
      list.add_sys("lockedspeed", locked_int[t]);
      break;
    }
   
  if(!list["lockedspeed"])
    init_error("illegal locked speed");

  read_token(init);
  strncpy(initstring, token, 256);

  dprintf(">initstring = %s, delay = %d, lockspeed = %d\n", 
	  initstring, device_delay, list["lockedspeed"] -> get_i());
   
  fclose(init);
}

int dump_file(char *file)
{
  char buf[256];
  FILE *f;
  
  f = fopen(file, "r");
  if(!f)
    return 1;
    
  for(;;) {
    if(!fgets(buf, 256, f))
      break;
    output_cooked(buf);
  }
   
  fclose(f);
  if(ansi)
    output_raw("\033[0m");

  return 0;
}

int more_file(char *file)
{
  FILE *fp;
  int lines, y, eof = 0, forever = 0;
  char buf[160], c, *prompt;
   
  lines = number("lines");   
  output_cooked("\\c");
  dprintf(">more_file: %s\n", file);
   
  fp = fopen(file, "r");
  if(!fp)
    return 1;
   
  prompt = (char *)malloc(1024);
  cook("$moreprompt$ $yesprompt$ $noprompt$ $contprompt$");
  strcpy(prompt, out_buf);

  y = 1;

  for(;!eof;) {
    if(!fgets(buf, 160, fp))
      eof = 1;
    else
      output_cooked(buf);
    
    if(!forever)
      y++;
     
    if(y == lines && !eof) {
      output_cooked(prompt);
      c = read_char();
      if(c == no_key) {
	fclose(fp);
        return 0;
      }
      else if(c == cont_key)
	forever = 1;
      y = 1;
      output_raw('\n');
    }
  }
   
  fclose(fp);
  free(prompt);

  output_cooked(string("pressanykey"));
  read_char();
  return 0;
}

