/* listed.c - view a directory as a listed directory
 *
 * $Id: listed.c,v 1.1 2002/01/30 22:32:53 ivarch Exp $
 */

#include <stdlib.h>
#include <signal.h>
#include <time.h>
#include "terminal.h"
#include "viewmenu.h"
#include "ldb.h"


void sh_cont (int);					/* SIGCONT handler */
int read_menu (char *, char *, char *, char *, int);	/* menu viewer */


typedef void (*sighandler_t)(int);


/* View "file" as a listed directory in the menu viewer.
 *
 * If "ldbfile" is not null, it is used to read and store the last access
 * details in and will be created if it does not already exist.
 */
int mview_listed (char * file, char * ldbfile) {
  sighandler_t oh;
  struct LDB d;
  int e;

  t_init (getenv ("TERM"));
  t_echo_off ();
  t_canon_off ();

  oh = signal (SIGCONT, sh_cont);

  ldb_read (ldbfile, file, &d);			/* read LDB entry for menu */

  e = read_menu (file, ldbfile, 0, 0, MENUFLAG_LISTED);	/* view the menu */

  if (e != 2) {
    d.last_accessed = time (0);
    ldb_write (ldbfile, &d);			/* store LDB entry */
  }

  t_echo_on ();
  t_canon_on ();

  signal (SIGCONT, oh);

  return (e > 1);
}

/* EOF */
