/* strncat.c - safely append one string to another
 *
 * $Id: strncat.c,v 1.1.1.1 1999/12/02 20:03:27 ivarch Exp $
 */


/* Append at most "*n" bytes of "src" to "dest", and update "*n" to reflect
 * the amount of space left. The string in "dest" is always null terminated.
 *
 * Returns nonzero if the whole string could not be appended; if so, "dest"
 * is reset to its original size and "*n" is restored. This is a bit wasteful
 * as the string is actually transferred but the old terminator is stuck back
 * in when it becomes apparent that there isn't room; perhaps a faster
 * alternative should be coded.
 */
int mstrncat (char * dest, char * src, int * n) {
  char * ptr;
  int oldn;

  if ((!dest) || (!src) || (!n)) return (1);

  if (*n <= 1) return (1);	/* need at least 2 bytes, one for terminator */

  while (*dest) dest ++;		/* find the end of "dest" */

  oldn = *n;
  ptr = dest;

  while (((*n) > 1) && (*src)) {
    *dest = *src;
    dest ++;
    src ++;
    *dest = 0;
    (*n) --;
  }

  if (*src == 0) return (0);

  *ptr = 0;
  *n = oldn;
  return (1);
}

/* EOF */
