/* length.c - find number of printable characters in string
 *
 * $Id: length.c,v 1.1.1.1 1999/12/02 20:03:25 ivarch Exp $
 */

#include "mstring.h"


/* Return the number of printable characters in "str", skipping over
 * attribute sequences. Backspaces are handled, and tabs are expanded.
 */
int mstrlen (char * str) {
  int n = 0, s = 0;

  if (!str) return (0);

  while (str[s] != 0) {
    if (miscntl(str[s])) {			/* skip attributes */
      mtribval (str, &s);
    } else if (str[s] == 8) {			/* ^H = backspace */
      s ++;
      n --;
      if (n < 0) n = 0;
    } else if (str[s] == 9) {			/* ^I = tab */
      s ++;
      n ++;
      while ((n % 8) != 0) n ++;
    } else {
      s ++;
      n ++;
    }
  }

  return (n);
}

/* EOF */
