/* backspace.c - process and remove backspaces from string
 *
 * $Id: backspace.c,v 1.1.1.1 1999/12/02 20:03:24 ivarch Exp $
 */

#include "mstring.h"


/* Strip all backspaces from "str". They are handled like this: each time a
 * backspace is encountered, the last "normal" character (i.e. not part of an
 * attribute sequence) is deleted, and so is the backspace, and then the
 * string scan starts again. This repeats until all backspaces have been
 * removed.
 */
void mstripbs (char * str) {
  int i, j;

  if (!str) return;

  i = 0;
  j = -1;
  while (str[i] != 0) {
    if (miscntl (str[i])) {	/* found attribute sequence start */
      mtribval (str, &i);		/* skip entire sequence */
    } else if (str[i] == 8) {	/* found backspace */
      mstrdelete (str, i, 1);		/* delete it */
      if (j >= 0) {			/* is there a char to delete? */
        mstrdelete (str, j, 1);			/* yes - remove it */
        j = -1;					/* and restart string scan */
        i = 0;
      }					/* no - continue loop at this index */
    } else {			/* must be a normal character */
      j = i;				/* remember its index */
      i ++;
    }
  }
}

/* EOF */
