/* menucmd.h - internal header file for menu commands
 *
 * $Id: menucmd.h,v 1.1.1.1 1999/12/02 20:03:21 ivarch Exp $
 */

#ifndef _MT_MENUCMD_H
#define _MT_MENUCMD_H

#ifndef _MT_MENU_H
#include "menu.h"
#endif	/* _MT_MENU_H */


struct menu_cmddat_s {		/* menu command data structure */
  char * buf;				/* string containing command line */
  menu_t * menu;			/* pointer to menu */
  menuentry_t * cur;			/* pointer to "current" entry */
  menuentry_t * dfl;			/* pointer to "default" entry */
  char nowprefix;			/* 1 if prefixed by "NOW" */
  char subprefix;			/* 1 if prefixed by "SUB" */
  char special;				/* 1 if "IF" being called specially */
};

typedef struct menu_cmddat_s * menu_cmddat_t;
typedef int (* menu_cmd_t)(menu_cmddat_t);

struct menu_status_s {		/* menu status type structure */
  char * name;				/* item name */
  unsigned long on;			/* bitfield to switch on */
  unsigned long off;			/* bitfield to switch off */
};


extern char * menu_path;
extern char * menu_temp;
extern char * menu_dfl_path;
extern int menu_f_skip;
extern int menu_f_quit;
extern struct menu_status_s menu_status_types[];

int menu_addentry (menu_t *);
void menu_envexpand (char *, long);

int menu__commentfile (menu_cmddat_t);
int menu__if (menu_cmddat_t);
int menu__else (menu_cmddat_t);
int menu__endif (menu_cmddat_t);
int menu__line (menu_cmddat_t);
int menu__log (menu_cmddat_t);
int menu__pathname (menu_cmddat_t);
int menu__quit (menu_cmddat_t);
int menu__status (menu_cmddat_t);
int menu__text (menu_cmddat_t);
int menu__title (menu_cmddat_t);
int menu__view (menu_cmddat_t);
int menu__viewalways (menu_cmddat_t);

#endif	/* _MT_MENUCMD_H */

/* EOF */
