/* commands.c - menu commands
 *
 * $Id: commands.c,v 1.1.1.1 1999/12/02 20:03:13 ivarch Exp $
 */

#include <stdlib.h>
#include <string.h>
#include "ldb.h"
#include "menucmd.h"


/* COMMENTFILE <file>
 */
int menu__commentfile (menu_cmddat_t d) {
  if (!d->buf) return (0);

  if (d->buf[0] == '/') {
    strncpy (menu_temp, d->buf, 1020);
  } else {
    strncpy (menu_temp, menu_path, 1000);
    strcat (menu_temp, "/");
    strncat (menu_temp, d->buf, 1000 - strlen (menu_temp));
  }

  free (d->cur->commentfile);
  d->cur->commentfile = strdup (ldb_filename (menu_temp));
  return (1);
}


/* LINE [<text>]
 */
int menu__line (menu_cmddat_t d) {
  if (menu_addentry (d->menu)) return (0);
  d->menu->menu[d->menu->num_entries - 1].type = 'l';
  d->menu->menu[d->menu->num_entries - 1].title =
    (d->buf) ? strdup (d->buf) : 0;
  return (1);
}


/* [NOW|SUBSEQUENT] LOG (TITLE|USER <file>)|CLEAR
 */
int menu__log (menu_cmddat_t d) {
  char * a;
  int t;

  if (!d->buf) return (0);
  a = strchr (d->buf, ' ');
  if (a) {
    *a = 0;
    a ++;
  }

  if (strncasecmp ("CLEAR", d->buf, strlen (d->buf)) == 0) {
    t = 0;
  } else if (strncasecmp ("TITLE", d->buf, strlen (d->buf)) == 0) {
    t = MENU_LOG_TITLE;
  } else if (strncasecmp ("USER", d->buf, strlen (d->buf)) == 0) {
    t = MENU_LOG_USER;
  } else {
    return (0);
  }

  if ((t != 0) && (!a)) return (0);

  if (t != 0) {
    if (a[0] == '/') {
      strncpy (menu_temp, a, 1020);
    } else {
      strncpy (menu_temp, menu_path, 1000);
      strcat (menu_temp, "/");
      strncat (menu_temp, a, 1000 - strlen (menu_temp));
    }
  }

  if (d->nowprefix) {					/* .NOW LOG */
    free (d->menu->logfile);
    d->menu->logfile = (t == 0) ? 0 : strdup (ldb_filename (menu_temp));
    d->menu->log_type = t;
  } else if (d->subprefix) {				/* .SUB LOG */
    free (d->dfl->logfile);
    d->dfl->logfile = (t == 0) ? 0 : strdup (ldb_filename (menu_temp));
    d->dfl->log_type = t;
  } else {						/* .LOG */
    free (d->cur->logfile);
    d->cur->logfile = (t == 0) ? 0 : strdup (ldb_filename (menu_temp));
    d->cur->log_type = t;
  }

  return (1);
}


/* PATHNAME [<path>]
 */
int menu__pathname (menu_cmddat_t d) {
  free (menu_path);
  if (d->buf) menu_path = strdup (ldb_filename (d->buf));
  else menu_path = strdup (menu_dfl_path);
  return (1);
}


/* QUIT
 */
int menu__quit (menu_cmddat_t d) {
  menu_f_quit = 1;
  return (1);
}


/* [NOW|SUBSEQUENT] STATUS [NOT] ...
 */
int menu__status (menu_cmddat_t d) {
  unsigned long on;
  unsigned long off;
  int invert = 0;
  char * a;
  int i, j;

  if (!d->buf) return (0);

  a = strtok (d->buf, " \011");

  while (a) {
    j = -1;

    if (strncasecmp ("NOT", a, strlen (a)) == 0) {
      invert = 1;
    } else {
      for (i = 0; (menu_status_types[i].name != 0) && j < 0; i ++) {
        if (strncasecmp (menu_status_types[i].name, a, strlen (a)) == 0) j = i;
      }
    }

    if (j >= 0) {
      if (!invert) {
        on = menu_status_types[j].on;
        off = menu_status_types[j].off;
      } else {
        on = menu_status_types[j].off;
        off = menu_status_types[j].on;
      }

      if (d->nowprefix) {				/* .NOW STATUS */
        if (on & MENU_STATUS_EDIT) d->menu->allow_edit = 1;
        else if (off & MENU_STATUS_EDIT) d->menu->allow_edit = 0;
      } else if (d->subprefix) {			/* .SUB STATUS */
        d->dfl->status -= (d->dfl->status & off);
        d->dfl->status |= on;
        d->cur->status -= (d->cur->status & off);
        d->cur->status |= on;
      } else {						/* .STATUS */
        d->cur->status -= (d->cur->status & off);
        d->cur->status |= on;
      }

      invert = 0;
    }

    a = strtok (0, " \011");
  }

  return (1);
}


/* TEXT [<text>]
 */
int menu__text (menu_cmddat_t d) {
  if (menu_addentry (d->menu)) return (0);
  d->menu->menu[d->menu->num_entries - 1].type = 't';
  d->menu->menu[d->menu->num_entries - 1].title =
    (d->buf) ? strdup (d->buf) : strdup ("");
  return (1);
}


/* TITLE ANIMATED|CENTRE|LEFT <file>
 */
int menu__title (menu_cmddat_t d) {
  char * a;

  if (!d->buf) return (0);
  a = strchr (d->buf, ' ');
  d->menu->title_type = 0;
  if (a) {
    a[0] = 0;
    a ++;
    if (strncasecmp ("ANIMATED", d->buf, strlen (d->buf)) == 0) {
      d->menu->title_type = MENU_TITLE_ANIMATED;
    } else if (strncasecmp ("CENTRE", d->buf, strlen (d->buf)) == 0) {
      d->menu->title_type = MENU_TITLE_CENTRE;
    }
  } else a = d->buf;

  free (d->menu->title);

  if (a[0] == '/') {
    strncpy (menu_temp, a, 1020);
  } else {
    strncpy (menu_temp, menu_path, 1000);
    strcat (menu_temp, "/");
    strncat (menu_temp, a, 1000 - strlen (menu_temp));
  }

  d->menu->title = strdup (ldb_filename (menu_temp));
 
  return (1);
}


/* [NOW] VIEW <file>
 */
int menu__view (menu_cmddat_t d) {
  if (!d->buf) return (0);

  if (d->buf[0] == '/') {
    strncpy (menu_temp, d->buf, 1020);
  } else {
    strncpy (menu_temp, menu_path, 1000);
    strcat (menu_temp, "/");
    strncat (menu_temp, d->buf, 1000 - strlen (menu_temp));
  }

  if (d->nowprefix) {
    free (d->menu->viewfile);
    d->menu->viewfile = strdup (ldb_filename (menu_temp));
    d->menu->viewalways = 0;
    return (1);
  }

  free (d->cur->viewfile);
  d->cur->viewfile = strdup (ldb_filename (menu_temp));
  d->cur->viewalways = 0;
  return (1);
}


/* [NOW] VIEWALWAYS <file>
 */
int menu__viewalways (menu_cmddat_t d) {
  if (!d->buf) return (0);

  if (d->buf[0] == '/') {
    strncpy (menu_temp, d->buf, 1020);
  } else {
    strncpy (menu_temp, menu_path, 1000);
    strcat (menu_temp, "/");
    strncat (menu_temp, d->buf, 1000 - strlen (menu_temp));
  }

  if (d->nowprefix) {
    free (d->menu->viewfile);
    d->menu->viewfile = strdup (ldb_filename (menu_temp));
    d->menu->viewalways = 1;
    return (1);
  }

  free (d->cur->viewfile);
  d->cur->viewfile = strdup (ldb_filename (menu_temp));
  d->cur->viewalways = 1;
  return (1);
}

/* EOF */
