/* hook.h - header file for BBS hooks
 *
 *   bbs_hook - call a hook function
 *
 * $Id: hook.h,v 1.1.1.1 1999/12/02 20:02:57 ivarch Exp $
 */

#ifndef _MT_HOOK_H
#define _MT_HOOK_H

typedef enum {		/* BBS hooks */
  HOOK_IN_BBS,			/* BBS active */
  HOOK_KEY_PRESSED,		/* any key pressed in any viewer */
  HOOK_KEY_FILE,		/* unknown key pressed in file viewer */
  HOOK_KEY_MENU,		/* unknown key pressed in menu viewer */
  HOOK_MENU_TYPE,		/* unknown menu entry type being loaded */
  HOOK_MENU_ACTION,		/* unknown action activated in menu */
  HOOK_MENU_BIN,		/* binary menu entry activated */
  HOOK_SET_ACTION,		/* set current action */
  HOOK_SET_KEYPATH,		/* set current keypath */
  HOOK_DROP_PRIVS,		/* drop privileges */
  HOOK_XRATED_ITEM,		/* entering an X-rated menu item */
  HOOK_VET_COMMAND,		/* vet a UNIX command given in a menu */
  HOOK_LOOKUP_EMAIL,		/* look up an email address */
  HOOK_IS_EXTERNAL,		/* return 1 if user is an external user */
  HOOK_IS_GUEST,		/* return 1 if user is a guest */
  HOOK_LOCATION,		/* fill in machine user logged in from */
  HOOK_SITECHECK,		/* check user's email address */
  HOOK_USERCHECK,		/* check whether user is in userlist file */
  HOOK_LOG_ADD,			/* log entry addition */
  HOOK_LOG_DELETE,		/* log entry deletion */
  HOOK_LOG_EDIT,		/* log direct edit */
  HOOK_LOG_RUN,			/* log spool or exec */
  HOOK_LOG_MAIL,		/* log mail-to-self */
  HOOK_LOG_ACTION,		/* log a menu action to a log file */
  HOOK_LOG_CLIENT,		/* log the exit of a client */
  HOOK_ACL_CHECK,		/* check ACL for a menu entry */
  HOOK_GET_KEYPATH,		/* get current keypath */
  HOOK_GET_ACTION,		/* get current action */
  HOOK_CHECK_MSGS,		/* check for new messages */
  HOOK_CHECK_BAN,		/* check an action isn't banned */
  HOOK_MAX
} bbs_hook_t;

int bbs_hook (bbs_hook_t, void *, void *);

#endif	/* _MT_HOOK_H */

/* EOF */
