/* write.c - output string, expanding attribute codes
 *
 * $Id: write.c,v 1.1.1.1 1999/12/02 20:02:42 ivarch Exp $
 */

#include <stdio.h>
#include <string.h>
#include "mstring.h"
#include "terminal.h"


/* Output a string, expanding attribute codes. The string is not modified.
 */
void t_write (char * string) {
  char tmp [1024];

  if (string) {
    strncpy (tmp, string, sizeof (tmp) - 16);
    tmp[sizeof (tmp) - 16] = 0;
    string = strchr (tmp, '\n');
    if (!string) strcat (tmp, "\035CA\035Ca\035a");
  } else {
    strcpy (tmp, "\035CA\035Ca\035a");
  }

  mstrtoansi (tmp, sizeof (tmp));
  t_abswrite (tmp);
}

/* EOF */
