/* resize.c - deal with SIGWINCH (terminal resized) signal
 *
 * $Id: resize.c,v 1.2 2001/11/13 10:23:52 ivarch Exp $
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif	/* HAVE_CONFIG_H */
#include <stdlib.h>
#include <signal.h>
#include <time.h>
#include "terminal.h"


int t_f_resized = 0;			/* terminal resized flag */
int t_f_handler = 0;			/* handler initialised flag */
extern int rf_redraw;			/* redraw-screen-now flag */
extern int menuview_rescan_now;		/* reload-menu-now flag */
extern time_t menuview_last_resize;	/* last resize time */


#ifdef HAVE_LIBTERMCAP		/* only define functions if have termcap */

/* Actual SIGWINCH signal handler. Simply sets the "t_f_resized" flag to 1.
 */
void t_winch_handler (int s) {
  t_f_resized = 1;
  signal (SIGWINCH, t_winch_handler);
}


/* Initialise the terminal resizing signal handler if it hasn't already been
 * put in place.
 */
void t_sighandler (void) {
  if (t_f_handler) return;
  t_f_handler = 1;
  signal (SIGWINCH, t_winch_handler);
}


/* Check whether the terminal has resized, and if so, reinitialise the
 * terminal handling routines and then set "rf_redraw" to 1 to cause a
 * screen redraw. The "menuview_rescan_now" flag is set to cause the current
 * menu to be reloaded, and the terminal resize flag is then cleared.
 */
void t_checksize (void) {
  if (!t_f_resized) return;
  t_init (getenv ("TERM"));
  rf_redraw = 1;
  menuview_rescan_now = 1;
  menuview_last_resize = time (0);
  t_f_resized = 0;
}

#else	/* ! HAVE_LIBTERMCAP */	/* no termcap - functions useless */

void t_sighandler (void) {}
void t_checksize (void) {}

#endif	/* HAVE_LIBTERMCAP */

/* EOF */
