/* lineout.c - output a line of text
 *
 * $Id: lineout.c,v 1.1.1.1 1999/12/02 20:02:39 ivarch Exp $
 */

#include <stdio.h>
#include <string.h>
#include <time.h>
#include "mstring.h"
#include "terminal.h"


/* Output the line "line". If "anon" is nonzero, "From:" lines will have the
 * account name stripped from them.
 */
void t_lineout (char * line, int anon) {
  char buf[4096];
  char * a;

  if (!line) {
    t_write ("\n");
    return;
  }

  strncpy (buf, line, sizeof (buf) - 1);
  buf[sizeof (buf) - 1] = 0;

  mtagexpand (buf, sizeof (buf) - 10, t_cols + 1, anon, 0);

  a = strchr (buf, 10);		/* turn off attributes at line end */
  if (!a) strcat (buf, "\n");
  a = strchr (buf, 10);
  if (a) strcpy (a, "\035CA\035Ca\035a\n");

  t_write (buf);
}

/* EOF */
