/* centre.c - centre a line of text
 *
 * $Id: centre.c,v 1.1.1.1 1999/12/02 20:02:36 ivarch Exp $
 */

#include <string.h>
#include "mstring.h"
#include "terminal.h"


/* Centre a line of text. Note that "str" may be modified.
 */
void t_centre (char * str) {
  int a, i;

  if (mstrlen (str) >= t_cols) {
    a = mstrindex (str, t_cols - 1);
    strcpy (str + a, "\035a\035CA\035Ca\035R>\035r");
  }

  i = (t_cols - mstrlen (str)) / 2;

  while (i > 0) {
    if (i > 5)      {t_write ("      "); i -= 6;}
    else if (i > 4) {t_write ("     "); i -= 5;}
    else if (i > 3) {t_write ("    "); i -= 4;}
    else if (i > 2) {t_write ("   "); i -= 3;}
    else if (i > 1) {t_write ("  "); i -= 2;}
    else            {t_write (" "); i -= 1;}
  }

  t_write (str);
}

/* EOF */
