/* scan.c - do a scan
 *
 * $Id: scan.c,v 1.1.1.1 1999/12/02 20:02:24 ivarch Exp $
 */

#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <ctype.h>
#include <time.h>
#include "mstring.h"
#include "terminal.h"
#include "viewmenu.h"


time_t scan_last_update = 0;


/* Perform a single-pass scan.
 */
void menuview_scan (menudata_t data) {
  struct stat sb;
  char a[2];
  int c, i, j;

  c = toupper (t_getchar (0));
  if (c == 'Q') return;

  for (i = 0; i < data->menu->num_entries; i ++) {	/* check files */
    if (data->menu->menu[i].key == 0) continue;
    j = data->menu->menu[i].type;
    if ((j == MENU_ENTRY_COMMENTFILE)
         || (j == MENU_ENTRY_FORMATTED)
         || (j == MENU_ENTRY_READONLY)
         || (j == MENU_ENTRY_UNFORMATTED)
         || (j == MENU_ENTRY_VTANSI)) {
      if (data->menu->menu[i].status & MENU_STATUS_NOSCAN) continue;
      if (data->menu->menu[i].status & MENU_STATUS_NOLAST) continue;
      if (stat (data->menu->menu[i].filename, &sb)) continue;
      j = menu_status (&(data->menu->menu[i]), data->ldbfile, sb.st_mtime);
      if (j & MENU_ITEM_SKIP1) continue;
      if (j & MENU_ITEM_SKIP2) continue;
      if (j != 0) {
        if (data->quit == MENUQUIT_RETURN) return;
        menuview_action (data, &(data->menu->menu[i]));
        return;
      }
    }
  }

  for (i = 0; i < data->menu->num_entries; i ++) {	/* scan submenus */
    if (data->menu->menu[i].key == 0) continue;
    if ((data->menu->menu[i].type == MENU_ENTRY_MENU)
         || (data->menu->menu[i].type == MENU_ENTRY_LISTED)) {
      if (data->menu->menu[i].status & MENU_STATUS_NOSCAN) continue;

      j = menu_status (&(data->menu->menu[i]), data->ldbfile, sb.st_mtime);
      if (j & MENU_ITEM_SKIP1) continue;
      if (j & MENU_ITEM_SKIP2) continue;

      a[0] = data->menu->menu[i].key;
      a[1] = 0;

      if (time (0) > scan_last_update) {
        strcpy (data->buf, "[\035BQ\035b]:Quit  <\035B");
        strcat (data->buf, data->keypath);
        strcat (data->buf, a);
        strcat (data->buf, "\035b> ");
        strncat (data->buf, data->menu->menu[i].title,
                 (MENUVIEW_BUFLEN - 32) - strlen (data->buf));
        if (mstrlen (data->buf) >= t_cols) {
          data->buf[mstrindex (data->buf, t_cols - 2)] = 0;
          strcat (data->buf, "\035R>\035r");
        }
        strcat (data->buf, "\035a\035CA\035Ca");
        menuview_wipe_footer (data);
        t_goto (0, t_rows - 1);
        t_write (data->buf);
        scan_last_update = time (0);
      }

      if (stat (data->menu->menu[i].filename, &sb)) continue;
      c = toupper (t_getchar (0));
      if ((c == 'Q') || (c == 27) || (c == -27)) return;
      strcpy (data->buf, data->keypath);
      strcat (data->buf, a);
      j = read_menu (data->menu->menu[i].filename,
                     data->ldbfile, data->buf,
                     data->menu->menu[i].title,
                     MENUFLAG_SUB | MENUFLAG_SCAN
                     | ((data->menu->menu[i].type == MENU_ENTRY_LISTED) ?
                     MENUFLAG_LISTED : 0));
      if (j == MENUQUIT_ERROR) continue;
      if (j != (MENUQUIT_SCAN - 1)) return;
    }
  }

  data->quit = MENUQUIT_SCAN;
}

/* EOF */
