/* anim.c - action for menu item type 'A'
 *
 * $Id: anim.c,v 1.2 2001/11/13 10:23:52 ivarch Exp $
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif	/* HAVE_CONFIG_H */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "hook.h"
#include "terminal.h"
#include "viewmenu.h"

extern char * current_user;


/* Run the animation file described by "e".
 *
 * Relies on the external Manim interpreter program `qmanim', by Richard
 * Boulton <rjb37@cam.ac.uk>.
 */
void menuview_animation (menudata_t data, menuentry_t * e) {
  char buf[1024];
  char * nameline;
  char * p;
  int n;

  if (!e->filename) return;

  n = strspn (e->filename, "0123456789"		/* allow only these chars */
                           "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
                           "abcdefghijklmnopqrstuvwxyz"
                           "_-+./");
  if ((n >= 0) && (n < strlen (e->filename))) e->filename[n] = 0;

  bbs_hook (HOOK_SET_ACTION, 0,
            (e->status & MENU_STATUS_HIDETITLE) ? "" : e->title);
  bbs_hook (HOOK_SET_KEYPATH, data->buf, 0);

  if (!(e->status & MENU_STATUS_BARLOG)) bbs_hook (HOOK_LOG_RUN, e, data);

  strcpy (data->buf, data->file);
  p = strrchr (data->buf, '/');			/* work out CWD */
  if (p) *p = 0;

  p = getenv ("MANIM_PROG");		/* check for environment var */
  if (!p) p = QMANIM_PATH;

  nameline = getenv ("MVIEW_NAMELINE");
  if (!nameline) nameline = "";

  snprintf (buf, sizeof (buf) - 1, "exec '%s' -n '%s' -e '%s' '%s'", p,
            current_user, nameline, e->filename);

  t_echo_on ();
  t_canon_on ();
  menuview_system (buf, data->buf);
  t_init (getenv ("TERM"));
  t_echo_off ();
  t_canon_off ();
}

/* EOF */
