/* skipedit.c - skip edits, backwards and forwards
 *
 * $Id: skipedit.c,v 1.1.1.1 1999/12/02 20:01:45 ivarch Exp $
 */

#include "terminal.h"
#include "viewfile.h"


/* Move back so that the last datestamp line is at the top of the screen.
 */
void rf_skipedit_back (rf_data_t data) {
  long line;

  line = data->ldb_entry->current_line - t_rows;

  while ((line > 0) && (data->line_pos[line].type != MFILE_LINE_DATESTAMP)) {
    line --;
  }

  line += (t_rows - 1);

  if ((data->ldb_entry->current_line - line) < t_rows) {
    rf_scroll_back (data, data->ldb_entry->current_line - line);
  } else {
    data->ldb_entry->current_line = line;
    rf_redraw_screen (data);
  }
}


/* Move forward so that the next last datestamp line is at the top of the
 * screen.
 */
void rf_skipedit_forward (rf_data_t data) {
  long line;

  line = data->ldb_entry->current_line - (t_rows - 2);
  if (line < 0) line = 0;

  while ((line < data->num_lines)
         && (data->line_pos[line].type != MFILE_LINE_DATESTAMP)) line ++;

  line += (t_rows - 1);

  if ((line - data->ldb_entry->current_line) < t_rows) {
    rf_scroll_forward (data, line - data->ldb_entry->current_line);
  } else {
    data->ldb_entry->current_line = line;
    rf_redraw_screen (data);
  }
}

/* EOF */
