/* Internal.h - internal header file for VT100 emulation
 *
 * Note that some code and ideas were stolen from the Linux 2.0.34 kernel
 * source file `drivers/char/console.c'. Nevertheless, the implementation in
 * this library is incomplete.
 *
 * $Id: Internal.h,v 1.1.1.1 1999/12/02 20:00:52 ivarch Exp $
 */

#ifndef _IV_VT100INT_H
#define _IV_VT100INT_H

#ifndef _IV_VT100_H
#include "vt100.h"
#endif	/* IV_VT100_H */

#define VT_MAX_XTITLE	256	/* maximum length of xterm title */
#define VT_MAX_PAR	32	/* maximum number of parameters in sequence */

enum {				/* current escape sequence status codes */
  VT_ESnone,				/* not in an escape sequence */
  VT_ESesc,				/* starting escape sequence */
  VT_ESsquare,				/* started ESC [ */
  VT_EShash,				/* started ESC # */
  VT_ESpercent,				/* started ESC % */
  VT_ESsetG0,				/* started ESC ( */
  VT_ESsetG1,				/* started ESC ) */
  VT_ESnonstd,				/* started ESC ] */
  VT_ESgetpars,				/* reading parameters */
  VT_ESgotpars,				/* got all parameters */
  VT_ESxtitle,				/* setting xterm title */
  VT_ESfunckey				/* function key code */
};

struct VT_Info {		/* info on a virtual terminal */
  int rows;				/* number of rows */
  int cols;				/* number of columns */
  int x;				/* current X position */
  int y;				/* current Y position */
  unsigned short current_attr;		/* current attributes and colours */
  long pending;				/* actions pending */
  int esc_state;			/* ESC sequence state */
  int par[VT_MAX_PAR];			/* sequence parameters */
  int npar;				/* current parameter number */
  int xtpos;				/* xterm title data entry position */
  int question;				/* flag, set on ESC [ ? */
  int scroll_by;			/* number of lines to scroll */
  int new_x, new_y;			/* position to explicitly move to */
  int saved_x, saved_y;			/* saved cursor position */
  unsigned short saved_attr;		/* saved attributes */
  vt_outcall output_function;		/* string response function */
  vt_callback callback_function;	/* function for callbacks */
  long callback_mask;			/* bitmask of allowed callbacks */
  void * callback_pointer;		/* pointer to pass to callback func */
  unsigned char * text;			/* rows*cols of text */
  unsigned short * attrs;		/* rows*cols of attributes */
  char xtitle[VT_MAX_XTITLE];		/* current xterm title */
};

int vt100_clear_pending (vt_info);	/* clear pending actions */
int vt100_action (vt_info, long);	/* perform an action, or queue it */
int vt100_do_action (vt_info, long);	/* perform an action right now */

int vt100__lf (vt_info);		/* linefeed */
int vt100__ri (vt_info);		/* move up */
int vt100__id (vt_info);		/* return terminal ID */
int vt100__save_cur (vt_info);		/* save cursor and attributes */
int vt100__restore_cur (vt_info);	/* restore cursor and attributes */
int vt100__status (vt_info);		/* status report */
int vt100__cursor (vt_info);		/* send cursor position report */
int vt100__goto (vt_info);		/* move cursor */
int vt100__decalign (vt_info);		/* fill screen with 'E' */
int vt100__clear (vt_info);		/* clear all/part of screen/line */
int vt100__scroll_up (vt_info);		/* scroll screen up */
int vt100__scroll_down (vt_info);	/* scroll screen down */
int vt100__ins_line (vt_info);		/* insert line */
int vt100__del_line (vt_info);		/* delete line */
int vt100__ins_char (vt_info);		/* insert character */
int vt100__del_char (vt_info);		/* delete character */
int vt100__rendition (vt_info);		/* set graphics rendition */
int vt100__set_mode (vt_info);		/* set terminal mode */
int vt100__reset_mode (vt_info);	/* reset terminal mode */

#endif	/* _IV_VT100INT_H */

/* EOF */
