/* help.c - command-line help for mconv
 *
 * $Id: help.c,v 1.5 2001/11/14 00:04:37 ivarch Exp $
 */

#include <stdio.h>


/* Display command-line help for mconv.
 */
void display_help (int w, int h) {
  printf ("\
Usage: mconv [OPTIONS] [FILE]...\n\
Concatenate FILE(s), or standard input, to standard output, parsing\n\
attribute codes on the way.\n\
\n\
  -f, --file-input               input is standard MCONV file (default)\n\
  -m, --menu-input               input is menu code\n\
  -a, --ansi-input               convert ANSI colour text to MCONV attributes\n\
  -i, --menu-info                display information about a menu file\n\
\n\
  -h, --html-output              output HTML\n\
  -t, --text-output, --no-colour output plain text without colour\n\
  -c, --colour-output            output ANSI colour text (default for -m,-f)\n\
  -y, --anonymous                don't show accountnames in output\n\
  -g, --guest                    output menus as a guest user would see them\n\
  -d FILE, --ldb=FILE            use FILE as a last-access database\n\
  -n, --no-ldb                   don't use LDB (default if MVIEW_LDB is unset)\n\
  -u, --unbuffered               no line buffering on input and output\n\
  -w, --width=NUMBER             set screen width to NUMBER [%d]\n\
  -H, --height=NUMBER            set screen height to NUMBER [%d]\n\
\n\
      --help                     show this help and exit\n\
  -V, --version                  show version information and exit\n\
\n\
With no FILE, or when FILE is -, standard input is read.\n\
\n\
Report bugs to <mconv@ivarch.com>.\n\
", w, h);
}

/* EOF */
