/* html.c - convert BBS attribute string to HTML
 *
 * $Id: html.c,v 1.3 2001/11/14 00:04:37 ivarch Exp $
 */


#include <stdlib.h>
#include <string.h>
#include "mstring.h"


char * conv_html_str (long *, int *, int *, long, int);	/* [strhtml.c] */


/* Convert "str" to HTML from BBS-attributes text, where "str" is a
 * buffer whose maximum size is "size".
 *
 * Note that the string may be ended if a newline is found (although a
 * trailing newline is always left if one was there), and tabs are not
 * expanded to spaces.
 */
void conv_html (char * str, long size) {
  int a, b;
  long c;
  long current = 0;
  int fg = MTR_COL_WHITE;
  int bg = MTR_COL_BLACK;
  long prev;
  long trib;

  if (!str) return;

  mstripbs (str);			/* remove backspaces */

  a = 0;
  while ((a >= 0) && (str[a] != 0) && (str[a] != 10)) {
    a = mnexttrib (str, a);		/* find next attribute char */
    if (a < 0) break;			/* no more attributes */

    b = a;
    c = mtribval (str, &a);		/* find attribute value */
    trib = c - (c & MTR_COLOUR_MASK);	/* strip out any colour value */

    mstrdelete (str, b, a - b);		/* remove attribute from string */
    a = b;

    switch (trib) {			/* take action on attribute */
      case MTR_BOLD         :
      case MTR_UNDERLINE    :
      case MTR_STANDOUT     :
      case MTR_REVERSE      :			/* switch on */
      case MTR_FLASH        :

        mstrinsert (str, conv_html_str (&current, &fg, &bg, current | c, -1),
                    &a, size);
        break;

      case MTR_BOLD_OFF     :
      case MTR_UNDERLINE_OFF:
      case MTR_STANDOUT_OFF :
      case MTR_REVERSE_OFF  :			/* switch off */
      case MTR_FLASH_OFF    :
      case MTR_ALL_OFF      :

        mstrinsert (str,
                    conv_html_str (&current, &fg, &bg, current & (
                      ((c & MTR_BOLD_OFF) ? 0 : MTR_BOLD) |
                      ((c & MTR_UNDERLINE_OFF) ? 0 : MTR_UNDERLINE) |
                      ((c & MTR_STANDOUT_OFF) ? 0 : MTR_STANDOUT) |
                      ((c & MTR_REVERSE_OFF) ? 0 : MTR_REVERSE) |
                      ((c & MTR_FLASH_OFF) ? 0 : MTR_FLASH)
                    ), -1),
                    &a, size);
        break;

      case MTR_FORE_COLOUR  :			/* change colour */
      case MTR_BACK_COLOUR  :

        mstrinsert (str,
                    conv_html_str (&current, &fg, &bg, trib,
                                   c & MTR_COLOUR_MASK),
                    &a, size);
        break;

      default:				/* invalid attribute */

        prev = current;

        mstrinsert (str,
                    conv_html_str (&current, &fg, &bg,
                                   MTR_REVERSE | MTR_FLASH, -1),
                    &a, size);
        mstrinsert (str, "*", &a, size);
        mstrinsert (str,
                    conv_html_str (&current, &fg, &bg, prev, -1),
                    &a, size);

        break;
    }
  }
}

/* EOF */
