/* checkline.c - check whether a line contains special headers
 *
 * $Id: checkline.c,v 1.2 2000/08/08 15:50:21 ivarch Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "mstring.h"


/* Convert BBS date into time_t - ie something like "Fri Nov 22 14:08:09 1996"
 * to a number.
 *
 * Returns -1 if can't do it.
 */
time_t numerictime (char * time_string) {
  struct tm a;
  char * p;
  char * t;

  if (!time_string) return (-1);

  t = strdup (time_string);		/* don't touch the original string */
  if (!t) return (-1);

  p = strtok (t, "[] ");		/* first token = day name */
  if (!p) {
    free (t);
    return (-1);
  }

  p = strtok (0, "[] ");		/* second token = month name */
  if (!p) {
    free (t);
    return (-1);
  }

  a.tm_mon = 12;

  if (strncasecmp (p, "jan", 3) == 0) a.tm_mon = 0;
  if (strncasecmp (p, "feb", 3) == 0) a.tm_mon = 1;
  if (strncasecmp (p, "mar", 3) == 0) a.tm_mon = 2;
  if (strncasecmp (p, "apr", 3) == 0) a.tm_mon = 3;
  if (strncasecmp (p, "may", 3) == 0) a.tm_mon = 4;
  if (strncasecmp (p, "jun", 3) == 0) a.tm_mon = 5;
  if (strncasecmp (p, "jul", 3) == 0) a.tm_mon = 6;
  if (strncasecmp (p, "aug", 3) == 0) a.tm_mon = 7;
  if (strncasecmp (p, "sep", 3) == 0) a.tm_mon = 8;
  if (strncasecmp (p, "oct", 3) == 0) a.tm_mon = 9;
  if (strncasecmp (p, "nov", 3) == 0) a.tm_mon = 10;
  if (strncasecmp (p, "dec", 3) == 0) a.tm_mon = 11;

  if (a.tm_mon > 11) {
    free (t);
    return (-1);
  }

  p = strtok (0, "[] ");		/* third token = month day */
  if (!p) {
    free (t);
    return (-1);
  }

  a.tm_mday = atoi (p);

  p = strtok (0, "[] ");		/* fourth token = time hh:mm:ss */
  if (!p) {
    free (t);
    return (-1);
  }

  sscanf (p, "%d:%d:%d", &(a.tm_hour), &(a.tm_min), &(a.tm_sec));

  p = strtok (0, "[] ");		/* fifth token = year yyyy */
  if (!p) {
    free (t);
    return (-1);
  }

  a.tm_year = atol (p) - 1900;

  a.tm_isdst = -1;

  free (t);

  return (mktime (&a));
}


/* Check whether "s" contains the expanded version of a BBS special
 * header such as "Message:" or "From:", and if so, contract it to the
 * original form (i.e. a datestamp line becomes a Message: tag, and so on).
 *
 * Buffer "s" is assumed to have a maximum possible length of "l".
 */
void ansi_checkline (char * s, int l) {
  int a;
  char * p;
  static char buf [32];

  if (!s) return;

  if (!strncmp (s, "Subject:", 8)) {	/* Subject: line - strip ]U]CC */
    a = mnexttrib (s, 7);
    if ((a > 0) && (s[a+1] == 'U') && (miscntl (s[a+2])) && (s[a+3] == 'C')
        && (s[a + 4] == 'C')) {
      mstrdelete (s, a, 5);
      a = mnexttrib (s, 7);
      if (a == (strlen (s) - 5)) s[a] = 0;
    }
    return;
  }

  if (!strncmp (s, "From:", 5)) {	/* From: line - strip ]B]CG */
    a = mnexttrib (s, 4);
    if ((a > 0) && (s[a+1] == 'B') && (miscntl (s[a+2])) && (s[a+3] == 'C')
        && (s[a + 4] == 'G')) {
      mstrdelete (s, a, 5);
      a = mnexttrib (s, 4);
      if (a == (strlen (s) - 5)) s[a] = 0;
    }
    return;
  }

  if (!strncmp (s, "To:", 3)) {		/* To: line - strip ]CG */
    a = mnexttrib (s, 2);
    if ((a > 0) && (s[a+1] == 'C') && (s[a+2] == 'G')) {
      mstrdelete (s, a, 3);
      a = mnexttrib (s, 2);
      if (a == (strlen (s) - 3)) s[a] = 0;
    }
    return;
  }

  if (!((miscntl (s[0])) && (miscntl (s[2])) && (miscntl (s[4]))
        && (s[1] == 'B') && ((s[3] == 'R') || (s[3] == 'S')) && (s[5] == 'C')
        && (s[6] == 'b'))) {
    return;
  }

  a = strspn (s + 7, "-");
  if (a < 50) return;

  p = strrchr (s, ']');

  if (p) {				/* possible datestamp */

    if (strcmp (p, "]--\035a\035Ck")) return;
    p -= 2;
    p[0] = 0;
    p = strchr (s, '[');
    p += 5;

    if (strlen (p) > 25) return;
    strcpy (buf, p);

    sprintf (s, "Message: %08lX             (%s)", numerictime (buf), buf);
    return;

  } else {				/* possible separator (no date) */

    if (a < 75) return;
    if ((miscntl (s[a+7])) && (s[a+8] == 'a') && (miscntl (s[a+9]))
        && (s[a+10] == 'C') && (s[a+11] == 'k') && (s[a+12] == 0)) {
      strcpy (s, "Message:");
      return;
    }

  }
}

/* EOF */
