/* callback.c - callback function for terminal emulator
 *
 * $Id: callback.c,v 1.1.1.1 1999/12/02 20:00:27 ivarch Exp $
 */

#include <stdio.h>
#include "vt100.h"


void mtrib_ansi_linefeed (vt_info);
void mtrib_ansi_goto (vt_info);
void mtrib_ansi_xtitle (vt_info);


/* Callback function for the terminal emulation library - outputs lines when
 * a newline is received, outputs blank lines if many lines are skipped with
 * an absolute cursor positioning command, and deals with xterm title changes.
 */
int mtrib_ansi_callback (vt_info vt, long reason, void * ptr) {

  switch (reason) {
    case VT_ACTION_LF : mtrib_ansi_linefeed (vt); break;
    case VT_ACTION_GOTO : mtrib_ansi_goto (vt); break;
    case VT_ACTION_XTITLE : mtrib_ansi_xtitle (vt); break;
  }

  return (0);
}

/* EOF */
