/* ansi.c - deal with ANSI colour text stream
 *
 * $Id: ansi.c,v 1.2 2000/08/08 15:50:21 ivarch Exp $
 */

#include <stdio.h>
#include "vt100.h"


int mtrib_ansi_callback (vt_info, long, void *);	/* terminal callback */


/* Process input stream "fptr", converting ANSI colour text from a terminal
 * of width "w" and height "h" to BBS attribute format.
 *
 * Returns nonzero on error, and the error is not reported.
 */
int mtrib_ansi (FILE * fptr, int w, int h) {
  char ibuf [256];
  vt_info vt;

  vt = vt100_create (w, h, 0);
  if (!vt) return (1);

  vt100_callback_set (vt, mtrib_ansi_callback);
  vt100_callback_ptr (vt, 0);
  vt100_callback_mask (vt, VT_ACTION_LF | VT_ACTION_GOTO |
                           VT_ACTION_XTITLE);

  while (!feof (fptr) && !ferror (fptr)) {
    ibuf[0] = 0;
    fgets (ibuf, 255, fptr);
    vt100_interpret (vt, ibuf);
  }

  vt100_destroy (vt);

  if (ferror (fptr)) return (1);
  return (0);
}

/* EOF */
