/* compose.c - message composition functions
 *
 * $Id: compose.c,v 1.1.1.1 1999/12/02 19:59:55 ivarch Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/stat.h>
#include <unistd.h>
#include "viewmenu.h"
#include "terminal.h"
#include "mstring.h"
#include "hook.h"
#include "u2u.h"
#include "bbs.h"


extern int ed_main (char *, long, char *, char *);
extern void uo_genlist (void);
extern uo_info_t * uo_list;
extern int uo_list_len;
extern int hook_check_ban (char *);


/* Ask the user to enter the intended recipients of a message, and return a
 * strdup()ed list of usernames, space-delimited, or 0 if nothing valid was
 * given.
 *
 * Returns 0 after reporting an error if the user is banned from sending
 * messages.
 */
char * u2u_get_recipients (void) {
  char buf[256];
  char buf2[256];
  long n;
  int i, j;

  t_goto (0, t_rows - 1);
  t_clrtoeol ();

  if (hook_check_ban ("2")) {		/* banned from sending messages */
    t_centre ("\035R  *** You are banned from sending messages ***  \035r");
    sleep (2);
    return (0);
  }

  buf[0] = 0;

  do {
    n = t_input ("Send message to: ", buf, sizeof (buf) - 1);
  } while (n == 1);

  j = 0;
  buf2[j] = 0;
  for (i = 0; i < strlen (buf); i ++) {
    if ((buf[i] == '.') || (buf[i] == '/') || (buf[i] == ',') ||
        (buf[i] == ' ')) {
      if ((j > 0) && (buf2[j-1] != ' ')) {
        buf2[j] = ' ';
        j ++;
      }
    } else {
      buf2[j] = buf[i];
      j ++;
    }
  }

  buf2[j] = 0;

  if (strlen (buf2) < 1) return (0);

  return (strdup (buf2));
}


/* Output a list of users who are not logged in (n == 1), ignoring messages
 * (n == 2), or undeliverable (n == 3).
 */
void u2u_send_to__iter (char * recipients, int n) {
  struct stat sb;
  char buf[1024];
  char * user;
  int i, f;

  if (n == 1) uo_genlist ();

  recipients = strdup (recipients);		/* make a copy of the string */

  user = strtok (recipients, " ");

  while (user) {

    if (n == 1) {			/* check whether user is logged in */
      f = 0;
      for (i = 0; i < uo_list_len; i ++) {
        if (!strcmp (uo_list[i].username, user)) f = 1;
      }
      if (!f) printf (" %s", user);
    } else if (n == 2) {		/* check if user ignoring messages */
      sprintf (buf, "%s/%s.ign", cf_str ("u2u"), user);
      if (!stat (buf, &sb)) printf (" %s", user);
    } else {				/* check user's messages file exists */
      sprintf (buf, "%s/%s", cf_str ("u2u"), user);
      if (stat (buf, &sb)) printf (" %s", user);
    }

    user = strtok (0, " ");
  }

  free (recipients);
}


/* Compose a message to "recipients" in the editor, give a post-composition
 * menu, and deliver the message if applicable.
 */
void u2u_send_to (char * recipients) {
  static char * menu[] = {
    "\n",
    "               [\035BA\035b] - Re-Edit Message\n",
    "\n",
    "           [\035BSPACE\035b] - Send Message\n",
    "               [\035BP\035b] - Postpone Message and Edit Later\n",
    "\n",
    "               \035CR[\035BQ\035b]\035CA - Cancel Message\n",
    "\n",
    0
  };
  char buf[1024];
  char obuf[1024];
  int e, i, c;

  if (hook_check_ban ("2")) {		/* banned from sending messages */
    t_abswrite ("\a");
    return;
  }

  sprintf (buf, "Send Message to %s", recipients);

  bbs_hook (HOOK_SET_ACTION, "Send Message to ", recipients);
  bbs_hook (HOOK_SET_KEYPATH, "", 0);

  e = ed_main (u2u_create_file (recipients), 0, buf, 0);
  if (e != 0) {
    u2u_remove_file (recipients);
    return;
  }

  rf_redraw = 1;

  do {

    if (rf_redraw) {
      t_clear ();

      obuf[0] = 0;

      i = (t_cols - mstrlen (buf)) / 2;
      while ((i > 0) && (strlen (obuf) < (sizeof (obuf) - 16))) {
        strcat (obuf, " ");
        i --;
      }
      strncat (obuf, buf, sizeof (obuf) - 16);
      if (mstrlen (obuf) >= t_cols) {
        obuf[mstrindex (obuf, t_cols - 1)] = 0;
        strcat (obuf, "\035R>\035r");
      }
      strcat (obuf, "\035a\035CA\035Ca");

      t_lineout (obuf, 0);

      strcpy (obuf, "\035CB");
      for (i = 0; (i < t_cols) && (i < (sizeof (obuf) - 16));
           i ++) obuf[i+3] = '~';
      obuf[i+3] = 0;
      strcat (obuf, "\035CA");

      t_lineout (obuf, 0);

      t_write ("    \035BRecipients not logged in:\035b");
      u2u_send_to__iter (recipients, 1);
      printf ("\n");
      t_write ("\035BRecipients ignoring messages:\035b");
      u2u_send_to__iter (recipients, 2);
      printf ("\n");
      t_write ("    \035BUndeliverable recipients:\035b");
      u2u_send_to__iter (recipients, 3);
      printf ("\n");

      for (i = 0; menu[i]; i ++) {	/* show menu */
        strcpy (buf, menu[i]);
        t_lineout (buf, 0);
      }
      rf_redraw = 0;
    }

    c = t_getchar (1);

    bbs_hook (HOOK_KEY_PRESSED, 0, &c);

    t_checksize ();

    if (menuview_exitup) c = 'Q';

    switch (toupper (c)) {

      case 12 : rf_redraw = 1; break;

      case 'A':
        ed_main (u2u_create_file (recipients), 0, buf, 0);
        rf_redraw = 1;
        break;

      case 'P': return;

      case 'Q':
        u2u_remove_file (recipients);
        return;

      default: break;
    }
  } while (c != ' ');

  u2u_deliver (recipients);
  u2u_remove_file (recipients);
}

/* EOF */
