/* issysop.c - check whether a user is a sysop or not
 *
 * $Id: issysop.c,v 1.1.1.1 1999/12/02 19:59:39 ivarch Exp $
 */

#include <string.h>
#include "bbs.h"


/* Return 1 if the user "user" is one of the users listed as "sysop".
 */
int bbs_is_sysop (char * user) {
  char buf[1024];
  char * a;

  strncpy (buf, cf_str ("sysop"), 1023);
  buf[1023] = 0;

  a = strtok (buf, " \011");
  while (a) {
    if (!strcmp (user, a)) return (1);
    a = strtok (0, " \011");
  }

  return (0);
}

/* EOF */
