/* xrated.c - display warning on entering an X-rated menu item
 *
 * $Id: xrated.c,v 1.1.1.1 1999/12/02 20:00:18 ivarch Exp $
 */

#include <stdlib.h>
#include <unistd.h>
#include "viewmenu.h"
#include "terminal.h"
#include "bbs.h"

int hook_is_guest (void);


/* Return nonzero if the current user is not to enter entry "e".
 */
int hook_xrated_item (menudata_t data, menuentry_t * e) {
  char * a;
  int x;

  if (hook_is_guest ()) {	/* guests can't view X-rated material */
    t_goto (0, t_rows - 1);
    t_clrtoeol ();
    t_centre ("\035R  *** "
              "Guests are not permitted to view X-rated material"
              " ***  \035r");
    sleep (2);
    rf_redraw = 1;
    return (1);
  }

  a = getenv ("BBS_XWARN");
  if (!a) x = 0; else x = atoi (a);

  a = cf_str ("xwarn");

  if (!x) {			/* always view X-rated warning screen */

    return (menuview_viewalways (data, a, "X rating warning"));

  } else {			/* only view X-rated warning if changed */

    return (menuview_viewfile (data, a, "X rating warning"));

  }

  /* NOT REACHED */

  return (0);
}

/* EOF */
