/* email.c - email-related hook functions
 *
 * $Id: email.c,v 1.1.1.1 1999/12/02 20:00:12 ivarch Exp $
 */

#include <stdlib.h>
#include <string.h>
#include "bbs.h"

int hook_check_ban (char *);


/* Look up the current user's email address and store a pointer to it in
 * "*ptr". Returns nonzero if the current user is not allowed to send email.
 */
int hook_lookup_email (char ** ptr) {
  char * a;

  if (hook_check_ban ("M")) return (1);

  a = getenv ("BBS_EMAIL");
  if (!a) return (0);

  *ptr = a;

  return (0);
}


/* Return 1 if the current user's email address stub ends in "str".
 */
int hook_sitecheck (char * str) {
  char * a;

  a = getenv ("BBS_EMAIL");
  if (!a) return (0);

  a = strchr (a, '@');
  if (!a) return (0);

  a ++;

  if (strlen (a) > strlen (str)) return (0);

  if (!strcmp (str - strlen (a), a)) return (1);

  return (0);
}

/* EOF */
