#!/usr/bin/perl -w
#
# Generate a set of menus in each given directory which index all
# directories from there down. All menus will have links to "./.make.mn",
# "File Sizes" (list source file sizes), and "./src/include", as well as
# a link to the top of the source tree ("./index.mn").
#
# Use by running this script from the top directory of the package, eg
# "perl ./extra/codemenu.pl src autoconf extra", and view the results with
# "mview -m ./src/.index.mn", "mview -m ./autoconf/.index.mn", and so on.
#
# Note that any directories specified must be in the *current* directory and
# not have any /'s in their names, i.e. "foo" but not "/foo/bar" or "a/b/c".
#
# CVS directories are ignored.
#
# $Id: codemenu.pl,v 1.3 1999/12/08 16:08:21 ivarch Exp $

sub do_scandir;

foreach $arg (@ARGV) {
  do_scandir ("..", $arg);
}

sub do_scandir {
  local ($topdir, $dir) = @_;
  local @files;
  local @dirs;
  local %key = ();
  local %name = ();
  local $item;
  local $title;
  local $chosen;
  local $i;
  local $used = ".Q,\`";

  open (FILE, "find $dir -type f -maxdepth 1 -mindepth 1 |") || die;
  @files=sort grep {
    chop;
    s,^.*/([^/]*)$,$1,;		# strip leading directories
    s/^\..*$//;			# remove "hidden" files (.foo)
    s/^.*~$//;			# remove backup files (foo~)
    s/^.*\.[od]$//;		# remove object and dependency files (.o,.d)
    /./
  } <FILE>;
  close (FILE);

  open (FILE, "find $dir -type d -maxdepth 1 -mindepth 1 |") || die;
  @dirs = sort grep {chop; s/^.*\.[od]$//; s/^.*CVS$//; /./} <FILE>;
  close (FILE);

  foreach $item (@files,@dirs) {
    $title = $item;
    $title =~ s/^.*\/([^\/]+)$/$1/;
    $i = 0;
    do {
      $chosen = substr ($title, $i, 1);
      $chosen =~ tr/a-z/A-Z/;
      $chosen =~ s/Q/@/;
      $i ++;
    } while (($i < length ($title)) && (index ($used, $chosen) >= 0));
    if (index ($used, $chosen) >= 0) {
      $i = 64;
      while (($i < 91) && (index ($used, $chosen) >= 0)) {
        $i ++;
        $chosen = chr($i);
      }
    }
    $title =~ s/($chosen)/\035B$1\035b/i;
    $key{$item} = $chosen;
    $used .= $chosen;
    $name{$item} = $title;
  }

  open (FILE, "> $dir/.index.mn");
  chmod 0644, "$dir/.index.mn";
  print FILE ".SUB STATUS READONLY EDIT NOLAST BARLOG\n\n.LINE\n";
  print FILE "\035CMFile Sizes\n\% S ls -l @files;echo;df .\n\n";
  print FILE ".STATUS NOSCAN\n";
  print FILE "\035CGMake\n, M $topdir/.make.mn\n\n";
  if ($dir ne "src/include") {
    print FILE ".STATUS NOSCAN\n";
    print FILE "\035CGInclude\n` M $topdir/src/include/.index.mn\n\n"
  }
  print FILE ".STATUS NOSCAN\n";
  print FILE "\035CGTop directory of package\n> M $topdir/.index.mn\n\n";
  print FILE "\n.SUB STATUS NOT BARLOG\n.LINE\n";
  foreach $item (@files) {
    if ($item =~ /\.html$/) {
      print FILE ".STATUS BARLOG\n";
      print FILE "\035CC$name{$item}\n$key{$item} X ";
      print FILE "lynx -restrictions=all -nopause $item\n";
    } elsif ($item =~ /\.info$/) {
      print FILE ".STATUS BARLOG\n";
      print FILE "\035CC$name{$item}\n$key{$item} X info -f ./$item\n";
    } elsif ($item =~ /\.mn$/) {
      print FILE "\035CC$name{$item}\n$key{$item} M $item\n";
    } else {
      print FILE "\035CC$name{$item}\n$key{$item} C $item\n";
    }
  }
  print FILE "\n.LINE\n" if ($#dirs >= 0);
  foreach $item (@dirs) {
    print FILE "\n\035CG$name{$item}\n$key{$item} M $topdir/$item/.index.mn\n";
  }
  close (FILE);

  foreach $item (@dirs) {
    do_scandir ("../$topdir", $item);
  }
}

# EOF
