/* menu.h - header file for menu loading functions
 *
 *   menu_load   - read menu into memory from stream
 *   menu_status - return subscription/LDB info for menu entry
 *   menu_free   - free a returned menu structure
 *
 * Internal functions which may be useful elsewhere:
 *
 *   menu_addentry - extend array of menu entries by one
 *   menu_entry    - store a menu entry
 *
 * $Id: menu.h,v 1.1.1.1 1999/12/02 20:03:07 ivarch Exp $
 */

#ifndef _MT_MENU_H
#define _MT_MENU_H

#ifndef _MT_LDB_H
#include "ldb.h"
#endif	/* _MT_LDB_H */

#ifndef _STDIO_H
#include <stdio.h>
#endif	/* _STDIO_H */

#define MENU_ITEM_SKIP1		0x01		/* skip on scan pass 1 */
#define MENU_ITEM_SKIP2		0x02		/* skip on scan pass 2 */
#define MENU_ITEM_NOLDB		0x10		/* no LDB info for item */
#define MENU_ITEM_MODIFIED	0x20		/* some left to read in file */

#define MENU_STATUS_ADD		0x00000001	/* allow edit add */
#define MENU_STATUS_DELETE	0x00000002	/* allow edit delete */
#define MENU_STATUS_EDIT	0x00000004	/* allow direct edit */
#define MENU_STATUS_ANONYMOUS	0x00000008	/* file is anonymous */
#define MENU_STATUS_XRATED	0x00000010	/* X rated entry */
#define MENU_STATUS_NOTIME	0x00000020	/* don't show mtime */
#define MENU_STATUS_BARINFO	0x00000040	/* no [I]ndex */
#define MENU_STATUS_BARMAIL	0x00000080	/* no [M]ail */
#define MENU_STATUS_BARPRINT	0x00000100	/* no [P]rint */
#define MENU_STATUS_BARSENDRPLY	0x00000200	/* no [S]end Reply */
#define MENU_STATUS_LOWPRIORITY	0x00000400	/* hit on second scan */
#define MENU_STATUS_NOSCAN	0x00000800	/* don't scan into */
#define MENU_STATUS_NOLAST	0x00001000	/* no LDB entry */
#define MENU_STATUS_NOERRORS	0x00002000	/* no error report */
#define MENU_STATUS_NOINDEX	0x00004000	/* no recursive index */
#define MENU_STATUS_HIDETITLE	0x00008000	/* hide title from others */
#define MENU_STATUS_READONLY	0x00010000	/* item is readonly */
#define MENU_STATUS_BARLOG	0x00020000	/* hidden from system logs */
#define MENU_STATUS_BARDELETE	0x00040000	/* no [.][D] at all */

#define MENU_ENTRY_ANIMATION	'A'	/* animation */
#define MENU_ENTRY_BINARY	'B'	/* binary */
#define MENU_ENTRY_COMMENTFILE	'C'	/* comment file */
#define MENU_ENTRY_FORMATTED	'F'	/* formatted file */
#define MENU_ENTRY_LISTED	'L'	/* listed directory */
#define MENU_ENTRY_MENU		'M'	/* menu file */
#define MENU_ENTRY_READONLY	'R'	/* read-only file */
#define MENU_ENTRY_SPOOLED	'S'	/* spooled output */
#define MENU_ENTRY_TELNET	'T'	/* telnet connection */
#define MENU_ENTRY_UNFORMATTED	'U'	/* unformatted file */
#define MENU_ENTRY_VTANSI	'V'	/* VT/ANSI raw file */
#define MENU_ENTRY_EXECUTABLE	'X'	/* executable */

#define MENU_ENTRY_TEXT		't'	/* centred text */
#define MENU_ENTRY_LINE		'l'	/* line of repeated text */
#define MENU_ENTRY_BBS		'1'	/* special BBS entry */
#define MENU_ENTRY_INTERNAL	'2'	/* internal menu entry */

#define MENU_TITLE_ANIMATED	1	/* title is animated */
#define MENU_TITLE_CENTRE	2	/* title is centred */

#define MENU_LOG_TITLE		1	/* log entry title */
#define MENU_LOG_USER		2	/* log user nameline */

struct menu_s;
struct menu_entry_s;
typedef struct menu_s menu_t;			/* menu type */
typedef struct menu_entry_s menuentry_t;	/* menu entry type */

struct menu_s {			/* structure containing info about a menu */
  char * filename;			/* menu filename, fully resolved */
  char * title;				/* menu title filename, 0 if none */
  char * logfile;			/* menu logfile, 0 if none */
  char * owner;				/* name of menu owner */
  char * viewfile;			/* viewfile, 0 if none */
  char title_type;			/* title type */
  char log_type;			/* logging type */
  char viewalways;			/* 1 if always to view viewfile */
  char allow_edit;			/* 1 if menu can be edited */
  int num_entries;			/* number of entries in the menu */
  menuentry_t * menu;			/* array of menu entries */
};

struct menu_entry_s {		/* structure containing a menu entry */
  char * title;				/* item title or text */
  char * filename;			/* item filename or action */
  char * commentfile;			/* commentfile filename, or 0 */
  char * viewfile;			/* viewfile filename, or 0 */
  char * logfile;			/* logfile, or 0 */
  char type;				/* entry type (eg 'X') */
  char log_type;			/* logging type */
  char viewalways;			/* 1 if always to view viewfile */
  char key;				/* keypress to activate menu item */
  int param;				/* entry parameter (eg '&') */
  unsigned long status;			/* status flags */
};

extern char * menu_path;		/* directory current menu is in */

menu_t * menu_load (FILE *, char *);
int menu_status (menuentry_t *, char *, unsigned long);
void menu_free (menu_t *);

int menu_addentry (menu_t *);
void menu_entry (menuentry_t *, menuentry_t *, char *);

#endif	/* _MT_MENU_H */

/* EOF */
