/* getutent.c - replacement for some getutent(3) library functions
 *
 * Implements getutent(), getutline(), setutent() and endutent().
 *
 * $Id: getutent.c,v 1.4 2001/11/14 15:21:22 ivarch Exp $
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif	/* HAVE_CONFIG_H */
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <utmp.h>

#ifndef _PATH_UTMP
#define _PATH_UTMP "/var/adm/utmp"
#endif

static struct utmp utmp__buf;
static FILE * utmp__fptr = 0;


struct utmp * getutent (void) {
  if (!utmp__fptr) return (0);
  if (fread (&utmp__buf, sizeof (utmp__buf), 1, utmp__fptr) == 1)
    return (&utmp__buf);
  return (0);
}


#ifdef NEED_UTMP_CONST
struct utmp * getutline (const struct utmp * ut) {
#else	/* NEED_UTMP_CONST */
struct utmp * getutline (struct utmp * ut) {
#endif	/* NEED_UTMP_CONST */
  while (getutent ()) {
    if (!strcmp (utmp__buf.ut_name,ut->ut_line)) return (&utmp__buf);
  }
  return(0);
}


void setutent (void) {
  if (!utmp__fptr) {
    utmp__fptr = fopen (_PATH_UTMP, "r");
  } else {
    rewind (utmp__fptr);
  }
}


void endutent (void) {
  if (utmp__fptr) fclose (utmp__fptr);
  utmp__fptr = 0;
}

/* EOF */
